% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{test.prop.bs}
\alias{test.prop.bs}
\title{Hypothesis test of equal proportions in a between-subjects design}
\usage{
test.prop.bs(f, n)
}
\arguments{
\item{f}{vector of frequency counts of participants who have the attribute}

\item{n}{vector of sample sizes}
}
\value{
Returns a 1-row matrix. The columns are:
Chi-square - chi-square test statistic
df - degrees of freedom
p - p-value
}
\description{
Computes a Pearson chi-square test for equal population proportions for a
dichotomous response variable in a one-factor between-subjects design.
}
\examples{
f <- c(35, 30, 15)
n <- c(50, 50, 50)
test.prop.bs (f, n)

# Should return:
#      Chi-square df            p
# [1,]   17.41071  2 0.0001656958


}
\references{
\insertRef{Fleiss2003}{statpsych}
}
