% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{pi.score}
\alias{pi.score}
\title{Prediction interval for one score}
\usage{
pi.score(alpha, m, sd, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{estimated mean}

\item{sd}{estimated standard deviation}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Predicted - predicted score
\item df - degrees of freedom
\item LL - lower limit of the prediction interval
\item UL - upper limit of the prediction interval
}
}
\description{
Computes a prediction interval for the response variable score of one
randomly selected member from the study population.
}
\examples{
pi.score(.05, 24.5, 3.65, 40)

# Should return:
# Predicted  df       LL       UL
#      24.5  39 17.02546 31.97454
 

}
