% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.ci.agree}
\alias{size.ci.agree}
\title{Sample size for a G-index confidence interval}
\usage{
size.ci.agree(alpha, G, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{G}{planning value of G-index}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a population G-index of
agreement for two dichotomous ratings with desired confidence interval
precision. Set the G-index planning value to the smallest value within a
plausible range for a conservatively large sample size.
}
\examples{
size.ci.agree(.05, .8, .2)

# Should return:
# Sample size
#         139


}
