% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.bayes.normal}
\alias{ci.bayes.normal}
\title{Bayesian credible interval for a normal prior distribution}
\usage{
ci.bayes.normal(alpha, prior_mean, prior_sd, est, se)
}
\arguments{
\item{alpha}{alpha level for 1-alpha credibility interval}

\item{prior_mean}{mean of prior Normal distribution}

\item{prior_sd}{standard deviation of prior Normal distribution}

\item{est}{sample estimate}

\item{se}{standard error of sample estimate}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Posterior mean - posterior mean of Normal distribution
\item Posterior SD - posterior standard deviation of Normal distribution
\item LL - lower limit of the credible interval
\item UL - upper limit of the credible interval
}
}
\description{
Computes an approximate Bayesian credible interval for a normal prior
distribution. This function can be used with any parameter estimator
(e.g., mean, mean difference, linear contrast of means, slope coefficient,
standardized mean difference, standardized linear contrast of means, median,
median difference, linear contrast of medians, etc.) that has an approximate
normal sampling distribution. The mean and standard deviation of the posterior
normal distribution are also reported.
}
\examples{
ci.bayes.normal(.05, 30, 2, 24.5, 0.577)

# Should return:
# Posterior mean Posterior SD       LL       UL
#        24.9226    0.5543895 23.83602 26.00919


}
\references{
\insertRef{Gelman2004}{statpsych}
}
