% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statquote.R
\name{statquote}
\alias{statquote}
\alias{print.statquote}
\alias{as.data.frame.statquote}
\title{Function to display a randomly chosen statistical quote}
\usage{
statquote(ind, topic = NULL, source = NULL)

\method{print}{statquote}(x, width = NULL, ...)

\method{as.data.frame}{statquote}(x, row.names = NULL, optional = FALSE,
  ...)
}
\arguments{
\item{ind}{Optional index of a quote; if missing a random value is sampled from
the available quotations.}

\item{topic}{A character string, used to select a subset of the quotes based
on the assigned topics.}

\item{source}{A character string, used to select a subset of the quotes based
on the source for the quote.}

\item{x}{object of class \code{'statquote'}}

\item{width}{Optional column width parameter}

\item{...}{Other optional arguments}

\item{row.names}{see \code{\link{as.data.frame}}}

\item{optional}{see \code{\link{as.data.frame}}}
}
\value{
A character vector containing one randomly selected quote
   from the included data set. It is of class \code{statquote} for
   which an S3 print method will be invoked.
}
\description{
This function displays a randomly statistical quote from
a collection. The quotations are classified by topics
}
\examples{
 set.seed(1234)
 statquote()
 statquote(source="Tukey")
 statquote(topic="science")
 statquote(topic="history")

}
\seealso{
\code{\link{quote_topics}}, \code{\link{search_quotes}}, \code{\link{quotes}},
Inspired by: \code{gaussfact} (\code{https://github.com/eddelbuettel/gaussfacts}),
 \code{\link[fortunes:fortunes]{fortune}}
}
