% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_stats19}
\alias{get_stats19}
\title{Download, read and format STATS19 data in one function.}
\usage{
get_stats19(year = NULL, type = "accidents", data_dir = tempdir(),
  file_name = NULL, format = TRUE, ask = FALSE)
}
\arguments{
\item{year}{Single year for which file is to be downloaded.}

\item{type}{One of 'Accidents', 'Casualties', 'Vehicles'; defaults to 'Accidents'.
Or any variation of to search the file names with such as "acc" or "accid".}

\item{data_dir}{Parent directory for all downloaded files. Defaults to \code{tempdir()}.}

\item{file_name}{The file name (DfT named) to download.}

\item{format}{Switch to return raw read from file, default is \code{TRUE}.}

\item{ask}{Should you be asked whether or not to download the files? \code{TRUE} by default.}
}
\description{
Download, read and format STATS19 data in one function.
}
\section{Details}{

This function utilizes \code{dl_stats19} and \code{read_*} functions
and retuns a df. The file downloaded would be for a specific year (e.g 2017).

As this function uses \code{dl_stats19} function, it can download
many MB of data so ensure you have a sufficient disk space.
}

\examples{
\donttest{
get_stats19(year = 2017)
get_stats19(year = 2009)
}
}
\seealso{
\code{\link[=dl_stats19]{dl_stats19()}}

\code{\link[=read_accidents]{read_accidents()}}
}
