% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixer_functions.R
\name{get_variables}
\alias{get_variables}
\title{Extracts variables from the list of meta data}
\usage{
get_variables(metadata)
}
\arguments{
\item{metadata}{A list retrieved using the \link{retrieve_metadata} function.}
}
\value{
a tibble
}
\description{
Extracts the variables and sets them up in a tibble so it is easy to see
what settings each parameter should have to get the desired data.
}
\examples{
metadata <- statsDK::retrieve_metadata("BEV3A")
dplyr::glimpse(metadata)

# See the variables as a data frame
variables <- get_variables(metadata)
dplyr::glimpse(variables)

}
