% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_stcos.R
\name{mle_stcos}
\alias{mle_stcos}
\alias{mle_stcos_v2}
\title{MLE for STCOS Model}
\usage{
mle_stcos(z, v, H, S, K, init = NULL, optim_control = list(),
  optim_method = "L-BFGS-B")

mle_stcos_v2(z, v, H, S, K, init = NULL, optim_control = list(),
  optim_method = "L-BFGS-B")
}
\arguments{
\item{z}{Vector which represents the outcome; assumed to be direct
estimates from the survey.}

\item{v}{Vector which represents direct variance estimates from the survey.
The diagonal of the matrix \eqn{\bm{V}} described in the details.}

\item{H}{Matrix of overlaps between source and fine-level supports.}

\item{S}{Design matrix for basis decomposition.}

\item{K}{Variance of the random coefficient \eqn{\bm{\eta}}}

\item{init}{A list containing the initial values in the MCMC for
\code{sig2xi} and \code{sig2K}. If not specified, we select an
arbitrary initial value.}

\item{optim_control}{This is passed as the \code{control} argument to
\code{optim}. Note that the value \code{fnscale} is ignored if
specified.}

\item{optim_method}{Method to be used for likelihood maximization by
\code{optim}. Default is \code{L-BFGS-B}.}
}
\value{
A list containing maximum likelihood estimates.
}
\description{
MLE for STCOS Model
}
\details{
Maximize the likelihood of the STCOS model
\deqn{
  f(\bm{z} \mid \bm{\mu}_B, \sigma_K^2, \sigma_\xi^2)
  = \textrm{N}(\bm{z} \mid \bm{H} \bm{\mu}_B, \bm{\Delta}
  ),
  \quad \bm{\Delta} = \sigma_\xi^2 \bm{I} + \bm{V} + \sigma_K^2 \bm{S} \bm{K} \bm{S}^\top,
}
by numerical maximization of the profile likelihood
\deqn{
  \ell(\sigma_K^2, \sigma_\xi^2) =
  -\frac{N}{2} \log(2 \pi) -\frac{1}{2} \log |\bm{\Delta}| -\frac{1}{2} (\bm{z} -
  \bm{H} \hat{\bm{\mu}}_B)^\top \bm{\Delta}^{-1} (\bm{z} - \bm{H} \hat{\bm{\mu}}_B)
}
using
\eqn{
  \hat{\bm{\mu}}_B = (\bm{H}^\top \bm{\Delta}^{-1} \bm{H})^{-1}
  \bm{H}^\top \bm{\Delta}^{-1} \bm{z}.
}
}
\examples{
\dontrun{
demo = prepare_stcos_demo()
mle_out = mle_stcos(demo$z, demo$v, demo$S, demo$H, demo$K)
sig2K_hat = mle_out$sig2K_hat
sig2xi_hat = mle_out$sig2xi_hat
mu_hat = mle_out$mu_hat
}
}
