% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.r
\name{show_hawkes}
\alias{show_hawkes}
\alias{show_hawkes_GOF}
\title{Plot Hawkes intensity}
\usage{
show_hawkes(obj)

show_hawkes_GOF(obj, plot = TRUE, return_values = FALSE)
}
\arguments{
\item{obj}{Either object returned by \code{\link{fit_hawkes}}/\code{\link{fit_hawkes_cbf}} 
or a named list with elements \code{times} and \code{params}. If the latter, 
then \code{times} should be a numeric vector of observed time points, and 
\code{params} must contain, \code{alpha} (intensity jump after an event occurrence) 
and \code{beta} (exponential intensity decay). In addition, should contain 
either \code{mu} (base rate of the Hawkes process) or \code{background_parameters}
(parameter(s) for the assumed non-homogeneous background function;
could be a list of multiple values). May also contain \code{marks} (a vector of numerical marks).}

\item{plot}{Logical, whether to plot  goodness-of-fit plots. Default \code{TRUE}.}

\item{return_values}{Logical, whether to return GOF values. Default \code{FALSE}.}
}
\value{
\code{\link{show_hawkes}} returns a \code{gtable} object
with \code{geom_line} and \code{geom_histogram} values.

\code{\link{show_hawkes_GOF}} returns no value unless \code{return_values = TRUE},
in this case a list of interarrival times is returned.
}
\description{
Plots a Hawkes intensity function, options to extend to 
non-homogeneous background intensity.

Plots a number of goodness-of-fit plots for a fitted
Hawkes process. Includes 1) a comparison of the  compensator and observed 
events, 2) a histogram of transformed interarrival times, 3) a Q-Q plot of 
transformed interarrival times, and 4) the CDF of consecutive interarrival 
times, In addition, results of a Kolmogorov-Smirnov and
Ljung-Box hypothesis test for the interarrival times are printed.
}
\examples{
data(retweets_niwa, package = "stelfi")
times <- unique(sort(as.numeric(difftime(retweets_niwa, min(retweets_niwa),units = "mins"))))
params <- c(mu = 9, alpha = 3, beta = 10)
show_hawkes(list(times = times, params = params))
fit <- fit_hawkes(times = times, parameters = params)
show_hawkes(fit)
data(retweets_niwa, package = "stelfi")
times <- unique(sort(as.numeric(difftime(retweets_niwa, min(retweets_niwa),units = "mins"))))
params <- c(mu = 9, alpha = 3, beta = 10)
show_hawkes_GOF(list(times = times, params = params))
fit <- fit_hawkes(times = times, parameters = params)
show_hawkes_GOF(fit)
}
