% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_day_indices.R
\name{define_day_indices}
\alias{define_day_indices}
\title{Generate sequential day indices from ISO 8601 timestamps}
\usage{
define_day_indices(ts)
}
\arguments{
\item{ts}{Character vector of ISO 8601 timestamps
(e.g., `"2024-06-26T23:45:00+0100"`). Time zone offsets are handled
correctly when converting to `Date`.}
}
\value{
An integer vector of the same length as `ts`, where each element
  gives the index of the day the timestamp belongs to. The first unique
  date encountered is assigned index `1`, the second `2`, and so on.
}
\description{
Converts a vector of ISO 8601 timestamps into sequential day indices
(1, 2, 3, …), where each unique calendar date corresponds to a unique
integer. This is useful for looping over or summarizing data by day
when working with minute-level time series from wearables.
}
\examples{
ts <- c("2024-06-26T23:45:00+0100",
        "2024-06-27T00:15:00+0100",
        "2024-06-27T14:30:00+0100")
define_day_indices(ts)
# Returns: c(1, 2, 2)

}
\seealso{
[as.POSIXct()], [as.Date()]
}
