% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_modification-functions.R
\name{population_modification_functions}
\alias{population_modification_functions}
\alias{translocation}
\title{How the population is modified in a landscape.}
\usage{
translocation(source_layer, sink_layer, stages = NULL,
  effect_timesteps = 1)
}
\arguments{
\item{source_layer}{the name of a spatial layer in the landscape object with the locations
and number of individuals to translocate from. Note, this layer will have only zero
values if individuals are being introduced from outside the study area}

\item{sink_layer}{the name of a spatial layer in the landscape object with the locations
and number of individuals to translocate to. Note, this layer will have only zero
values if individuals are being controlled (e.g. culling)}

\item{stages}{which life-stages are modified - default is all}

\item{effect_timesteps}{which timesteps in a single simulation do the translocations
take place}
}
\description{
Pre-defined functions to define population modification (e.g. translocation) during a simulation.
}
\examples{

# Use the translocation_population_dynamics object to modify the  
# population using translocations:

test_translocation <- translocation(source_layer = "egk_source",
                                       sink_layer = "egk_sink",
                                       stages = NULL,
                                       effect_timesteps = 1)
}
