% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seffEst.R
\name{seffEst}
\alias{seffEst}
\title{STFIT Spatial Effect Estimation}
\usage{
seffEst(
  rmat,
  img.nrow,
  img.ncol,
  h.cov = 2,
  h.sigma2 = 2,
  weight.cov = NULL,
  weight.sigma2 = NULL,
  nnr,
  method = c("lc", "emp"),
  partial.only = TRUE,
  pve = 0.99,
  msk = NULL,
  msk.tol = 0.95,
  var.est = FALSE
)
}
\arguments{
\item{rmat}{residual matrix}

\item{img.nrow}{image row dimension}

\item{img.ncol}{image column dimension}

\item{h.cov}{bandwidth for spatial covariance estimation; ignored if \code{weight.cov} is supplied}

\item{h.sigma2}{bandwidth for sigma2 estimation}

\item{weight.cov}{weight matrix for spatial covariance estimation}

\item{weight.sigma2}{weight vector for spatial variance estimation}

\item{nnr}{maximum number of nearest neighbor pixels to use for spatial covariance estimation}

\item{method}{"lc" for local constant covariance estimation and "emp" for empirical covariance estimation}

\item{partial.only}{calculate the spatical effect for partially observed images only, default is TRUE}

\item{pve}{percent of variance explained of the selected eigen values. Default is 0.99.}

\item{msk}{an optional logistic vector. TRUE represent the corresponding pixel is always missing.}

\item{msk.tol}{if 'msk' is not given, the program will determine the mask using \code{getMask}
function. If the percentage of missing values for a pixel over time is greater than this}

\item{var.est}{Whether to estimate the variance of the temporal effect. Default is FALSE.}
}
\value{
List of length 3 with entries:
  \itemize{
    \item seff_mat: estimated spatial effect matrix of the same shape as \code{rmat}.
    \item seff_var_mat: estimated spatial effect variance matrix of the same shape as \code{rmat}.
    \item idx: a list of two entries:
    \itemize{
      \item idx.allmissing: index of the completely missing images.
      \item idx.imputed: index of the partially observed images, where spatial effects 
      are estimated.
    }
  }
}
\description{
STFIT Spatial Effect Estimation
}
