\name{plotQuote}
\alias{plotQuote}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Plots strings}
\description{
Plots strings to a blank canvas.  Used primarily for plotting quotes generated by \code{\link{findThoughts}}.}
\usage{
plotQuote(sentences, width = 30, text.cex=1, maxwidth=NULL, main=NULL, 
          xlab="", ylab="", xlim=NULL, ylim=NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{sentences}{
    Vector of sentence to plot.
    }
  \item{width}{
    Number of characters in each line.
    }
    \item{text.cex}{
    Sets the size of the text
    }
    \item{maxwidth}{
    Sets the maximum character width of the plotted responses rounding to the nearest word.
    Note that this may perform somewhat unexpectedly for very small numbers.
    }
      \item{main}{
    Title of plot.
    }
    \item{xlab}{
    Sets an x-axis label
    }
    \item{ylab}{
    Set a y-axis label
    }
    \item{xlim}{
    sets the x-range of the plot.
    }
    \item{ylim}{
    sets the y-range of the plot
    }
    \item{...}{
    other parameters passed to the plot function
    }
}

\details{
A simple function which wraps sentences at \code{width} characters per line and plots the results.}

\seealso{
\code{\link{findThoughts}}
}
\examples{
thoughts <- findThoughts(gadarianFit,texts=gadarian$open.ended.response,
topics=c(1), n=3)$docs[[1]]
plotQuote(thoughts)
}

