% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_themeset.R
\docType{class}
\name{Themeset}
\alias{Themeset}
\title{R6 class representing an LTO themeset}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \pkg{stoRy} package uses the \code{Themeset} R6 class to represent user
defined collections of themes. Themesets are currently in an experimental
stage of development, but can be expected to become an integrate part of
future \pkg{stoRy} package analysis functions.
}
\details{
Various themesets are hosted on the themesets Theme Ontology
GitHub repository \url{https://github.com/theme-ontology/themesets}.
}
\examples{
\dontrun{
# Initialize a themeset from file:
set_lto("demo")
file <- system.file("extdata/immortality.thset.txt", package = "stoRy")
themeset <- Themeset$new(file)

# Print themeset info to console:
themeset

#' # Read themeset from a url and print to console:
set_lto("demo")
file <- paste0(
  "https://raw.githubusercontent.com/theme-ontology/",
  "master/demo/immortality.thset.txt"
)
themeset <- Themeset$new(file)
themeset

# Initialize a themeset directly from a string and print to console:
set_lto("demo")
file <- I("Themeset: immortality
=====================

:: Description
Themes related to people living on well beyond what is considered to be a
normal human lifespan.

:: Component Themes
immortality
the flip side of immortality
the quest for immortality")
themeset <- Themeset$new(file)
themeset 
}
}
\seealso{
Use \code{\link[=Collection]{Collection()}} to initialize an collection of LTO thematically
annotated stories.

Use \code{\link[=Story]{Story()}} to initialize an LTO thematically annotated story.

Use \code{\link[=Theme]{Theme()}} to initialize an LTO theme.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Themeset$new()}}
\item \href{#method-themeset_id}{\code{Themeset$themeset_id()}}
\item \href{#method-description}{\code{Themeset$description()}}
\item \href{#method-component_theme_names}{\code{Themeset$component_theme_names()}}
\item \href{#method-size}{\code{Themeset$size()}}
\item \href{#method-obj_internal_tbl}{\code{Themeset$obj_internal_tbl()}}
\item \href{#method-print}{\code{Themeset$print()}}
\item \href{#method-clone}{\code{Themeset$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a collection of LTO themes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Themeset$new(file, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{Either a file name, a path to a file, a url, or a single
single must contain at least one newline to be recognized as such (as
string as opposed to a path or url). Files must end with the standard
.thset.txt extension used for themeset files.

If \code{file} is a file name, then the file is assumed to reside in the
current working directory.}

\item{\code{verbose}}{A logical value indicating whether status messages should be
output to console.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Themeset} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-themeset_id"></a>}}
\if{latex}{\out{\hypertarget{method-themeset_id}{}}}
\subsection{Method \code{themeset_id()}}{
return A length-one character vector corresponding to the themeset ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Themeset$themeset_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-description"></a>}}
\if{latex}{\out{\hypertarget{method-description}{}}}
\subsection{Method \code{description()}}{
return A length-one character vector corresponding to the themeset
description.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Themeset$description()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-component_theme_names"></a>}}
\if{latex}{\out{\hypertarget{method-component_theme_names}{}}}
\subsection{Method \code{component_theme_names()}}{
return A tibble of member themes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Themeset$component_theme_names()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-size"></a>}}
\if{latex}{\out{\hypertarget{method-size}{}}}
\subsection{Method \code{size()}}{
return A length-one numeric vector containing the number of themes in
the themeset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Themeset$size()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obj_internal_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-obj_internal_tbl}{}}}
\subsection{Method \code{obj_internal_tbl()}}{
a pre-computed table used internally by package functions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Themeset$obj_internal_tbl()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print collection object info to console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Themeset$print(canonical = FALSE, n = NULL, width = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{canonical}}{Set to FALSE for pretty output.}

\item{\code{n}}{Maximum number of component theme names to print to console.
This defaults to NULL which means the
\code{getOption("stoRy.print_min")} value is used. Run
\code{options(stoRy.print_min = 25L)} to set the minimum number of
printed component theme names to be 25. Run
\code{stoRy_opt("print_max")} to check the maximum number of themes
that can be printed to console. This value can be changed in the same
way as with \code{stoRy.print_min}.}

\item{\code{width}}{Width of text output to generate. This defaults to NULL,
which means the \code{stoRy_opt("width")} value is used. Run
\code{options(stoRy.width = 120L)} to change the column width to be 120
characters, etc.}

\item{\code{...}}{Additional arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Themeset$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
