% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart.R
\name{saveBARTModelToJsonFile}
\alias{saveBARTModelToJsonFile}
\title{Convert the persistent aspects of a BART model to (in-memory) JSON and save to a file}
\usage{
saveBARTModelToJsonFile(object, filename)
}
\arguments{
\item{object}{Object of type \code{bartmodel} containing draws of a BART model and associated sampling outputs.}

\item{filename}{String of filepath, must end in ".json"}
}
\value{
None
}
\description{
Convert the persistent aspects of a BART model to (in-memory) JSON and save to a file
}
\examples{
n <- 100
p <- 5
X <- matrix(runif(n*p), ncol = p)
f_XW <- (
    ((0 <= X[,1]) & (0.25 > X[,1])) * (-7.5) + 
    ((0.25 <= X[,1]) & (0.5 > X[,1])) * (-2.5) + 
    ((0.5 <= X[,1]) & (0.75 > X[,1])) * (2.5) + 
    ((0.75 <= X[,1]) & (1 > X[,1])) * (7.5)
)
noise_sd <- 1
y <- f_XW + rnorm(n, 0, noise_sd)
test_set_pct <- 0.2
n_test <- round(test_set_pct*n)
n_train <- n - n_test
test_inds <- sort(sample(1:n, n_test, replace = FALSE))
train_inds <- (1:n)[!((1:n) \%in\% test_inds)]
X_test <- X[test_inds,]
X_train <- X[train_inds,]
y_test <- y[test_inds]
y_train <- y[train_inds]
bart_model <- bart(X_train = X_train, y_train = y_train, 
                   num_gfr = 10, num_burnin = 0, num_mcmc = 10)
tmpjson <- tempfile(fileext = ".json")
saveBARTModelToJsonFile(bart_model, file.path(tmpjson))
unlink(tmpjson)
}
