% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochvol-package.R
\docType{data}
\name{exrates}
\alias{exrates}
\title{Euro exchange rate data}
\source{
ECB Statistical Data Warehouse (\url{http://sdw.ecb.europa.eu})
}
\description{
The data set contains the daily bilateral prices of one Euro in 23
currencies from January 3, 2000, until April 4, 2012. Conversions to New
Turkish Lira and Fourth Romanian Leu have been incorporated.
}
\examples{

\dontrun{
data(exrates)
dat <- logret(exrates$USD, demean = TRUE)  ## de-meaned log-returns
res <- svsample(dat)                       ## run MCMC sampler
plot(res, forecast = 100)                  ## display results
}

}
\seealso{
\code{\link{svsample}}
}
\keyword{datasets}
