% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.lista.R
\name{print.lista}
\alias{print.lista}
\title{Print a \code{lista} object}
\usage{
\method{print}{lista}(x, ...)
}
\arguments{
\item{x}{An object of class \code{lista}}

\item{...}{additional unused argument}
}
\description{
It prints the main information on the local network summary statistics
stored in a \code{lista} object.
}
\examples{

set.seed(2)
df_net <- data.frame(x = runif(25, 0, 0.85), y = runif(25, 0, 0.85), t = runif(25))
stlp1 <- stp(df_net, L = chicagonet)
lambda <- rep(diff(range(stlp1$df$x)) * diff(range(stlp1$df$y))
 * diff(range(stlp1$df$t)) / spatstat.geom::volume(stlp1$L),
nrow(stlp1$df))

k <- localSTLKinhom(stlp1, lambda = lambda, normalize = TRUE)

k


}
\author{
Nicoletta D'Angelo
}
