% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_conversions.R
\name{remove_forward_speed}
\alias{remove_forward_speed}
\title{Remove forward speed from maximum wind speed}
\usage{
remove_forward_speed(vmax, tcspd)
}
\arguments{
\item{vmax}{A numeric vector giving maximum 10-m 1-minute sustained wind (m / s)}

\item{tcspd}{A numeric vector giving the tropical cyclone's forward speed (m / s).}
}
\value{
A numerical vector with \eqn{V_{max,sym}}{Vmax,sym}, the storm's
maximum 10-m 1-min sustained wind with motion asymmetry removed, in m / s.
}
\description{
Removes the forward speed of the storm from the maximum storm wind speed,
\eqn{V_{max}}{Vmax}, to estimate \eqn{V_{max,sym}}{Vmax,sym}, the storm's
maximum 10-m 1-min sustained wind with motion asymmetry removed.
}
\details{
This function is based on equation 12 (and accompanying
   text) in Phadke et al. 2003. Based on this paper, the correction
   factor for forward speed is at its highest at the radius of
   maximum winds, where it equals 0.5 times the forward wind speed.
}
\references{
Phadke AC, Martino CD, Cheung KF, and Houston SH. 2003. Modeling of
   tropical cyclone winds and waves for emergency management. Ocean
   Engineering 30(4):553-578.
}

