% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo-functions.R
\name{bbox_scale}
\alias{bbox_scale}
\title{Scale a bounding box}
\usage{
bbox_scale(bb, scale_factor)
}
\arguments{
\item{bb}{the bounding box or spatial object that will be used to crop \code{shp}}

\item{scale_factor}{Number determining how much the bounding box will grow or shrink. If the value is 1, the output size will be the same as the input.}
}
\description{
Takes a bounding box as an input and outputs a bounding box of a different size, centred at the same point.
}
\examples{
# dput(bbox(cents))
bb <- structure(c(-1.55080650299106, 53.8040984493515, -1.51186138683098,
53.828874094091), .Dim = c(2L, 2L), .Dimnames = list(c("coords.x1",
  "coords.x2"), c("min", "max")))
bb1 <- bbox_scale(bb, 1.05)
bb1
bb2 <- bbox_scale(bb, 0.75)
bb2
bb3 <- bbox_scale(bb, 0.1)
plot(x = bb1[1,], y = bb1[2,])
points(bb2[1,], bb2[2,])
points(bb3[1,], bb3[2,])
points(bb[1,], bb[2,], col = "red")
bbox_scale(bb, 0.75)
}

