% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{append<-}
\alias{append<-}
\title{Add Elements to Vectors}
\usage{
append(x, after = length(x), nm = NULL, overwrite = TRUE) <- value
}
\arguments{
\item{x}{atomic vector, list vector, or list.}

\item{after}{either an integer vector with length 1 or a character vector of
length 1 specifying where to add \code{value}. If an integer vector, it is the position
of an element. If a character vector, it is the element with that name. Similar to
\code{append}, use 0L if you want the added elements to be first.}

\item{nm}{character vector of length equal to the \code{length(value)} that specifies
the names of \code{value} once added to \code{x} as elements. This is an optional
argument that defaults to NULL where the pre-existing names of \code{value} are used.}

\item{overwrite}{logical vector of length 1 specifying whether elements from
\code{value} or \code{nm} should overwrite elements in \code{x} with the
same names. Note, if \code{overwrite} = FALSE, repeat names are possible
similar to \code{append}.}

\item{value}{vector of the same typeof as \code{x} to be added as elements to \code{x}.
Note that for atomic vectors, if more complex elements are added, then the return
object will be typeof the most complex element in \code{x} and \code{value}.}
}
\value{
Like other similar functions (e.g., \code{`names<-`} and \code{`[<-`}),
it does not appear to have a return object. However, it technically does as a
side effect. The argument \code{x} will have been changed such that \code{value}
has been added as elements. If a traditional return object is desired, and no side
effects, then it can be called like a traditional function:
vec2 <- `append<-`(vec1, value = add1).
}
\description{
\code{`append<-`} adds elements to vectors as a side effect. The purpose of
the function is to replace the need to use vec2 <- append(vec1, add1);
vec3 <- append(vec2, add2); vec4 <- append(vec3, add3), etc. It functions similarly
to \code{`[<-.default`}, but allows you to specify the location of the elements
similar to \code{append} (vs. \code{c}).
}
\details{
Some traditional R folks may find this function uncomfortable. R is famous for limiting
side effects, except for a few notable exceptions (e.g., \code{`[<-`} and \code{`names<-`}).
Part of the reason is that side effects can be computationally inefficient in R.
The entire object often has to be re-constructed and re-saved to memory. For
example, a more computationally efficient alternative to append(vec) <- add1;
append(vec) <- add2; append(vec) <- add3 is vec1 <- do.call(what = c,
args = list(dat, add1, add2, add3)). However, \code{`append<-`} was not created
for R programming use when computational efficiency is valued; it was created
for R interactive use when user convenience is valued.
}
\examples{
x <- letters
append(x) <- LETTERS
append(x, after = match(x = "z", table = x)) <- "case_switch" # with the position
   # of the added value specified
y <- setNames(object = letters, nm = LETTERS)
append(y) <- c("ONE" = 1, "TWO" = 2, "THREE" = 3) # with names provided by `value`
y <- y[1:(length(y) - 3)]
append(y, nm = c("ONE","TWO","THREE")) <- c(1,2,3) # with names specified by `nm`
# using overwrite
append(y, overwrite = TRUE) <- c("ONE" = "one","TWO" = "two", "THREE" = "three")
append(y, overwrite = FALSE) <- c("ONE" = "one","TWO" = "two", "THREE" = "three")
}
