% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{lm2a}
\alias{lm2a}
\title{List of Matrices to 3D Array}
\usage{
lm2a(lm, dim.order = c(1, 2, 3), dimlab.list = NULL, check = TRUE)
}
\arguments{
\item{lm}{list of matrices which each have the same dimensions.}

\item{dim.order}{integer vector of length 3 specifying the order of dimensions for
the returned array. The default is \code{c(1,2,3)} which means the rows of the
matrices in \code{lm} is the first dimension (i.e., rows), the columns of the
matrices in \code{lm} is the second dimension (i.e., columns), and the list
elements of \code{lm} is the third dimension (i.e., layers).}

\item{dimlab.list}{character vector of length 1 specifying the dimlabel for
the list dimension.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{lm} is a list of matrices.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
3D array where the list elements of \code{lm} is now a dimension. The
order of the dimensions is determined by the argument \code{dim.order} with dimnames
specified by names(\code{lm}). The dimnames of the returned array is determined
by the dimnames in \code{lm[[1]]} and \code{names(lm)}.
}
\description{
\code{lm2a} converts a list of matrices to a 3D array where the list dimension
becomes the third dimension of the array (layers). \code{lm2a} is a simple
wrapper function for \code{abind::abind}.
}
\examples{
lm <- asplit(HairEyeColor, MARGIN = 3L)
lm2a(lm) # default
lm2a(lm, dimlab.list = "Sex")
lm2a(lm, dim.order = c(3,1,2))
lm2a(lm, dim.order = c(3,1,2), dimlab.list = "Sex")
}
