% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{is.POSIXlt}
\alias{is.POSIXlt}
\title{Test for a POSIXlt object}
\usage{
is.POSIXlt(x)
}
\arguments{
\item{x}{an object.}
}
\value{
TRUE is \code{x} has class "POSIXlt" and FALSE if \code{x} does not have class "POSIXlt".
}
\description{
\code{is.POSIXlt} returns whether an object is a POSIXlt object (aka has class = "POSIXlt").
}
\examples{
time <- as.POSIXlt("2021-05-24 21:49:11", tz = "America/New_York",
   format = "\%Y-\%m-\%d \%H:\%M:\%OS") # as.POSIXlt.character
is.POSIXlt(time)
class(time) <- append(class(time), "extra_class")
is.POSIXlt(time) # classes other than POSIXlt are allowed
is.POSIXlt(list(time)) # returns FALSE
}
