% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratEst.R
\name{stratEst}
\alias{stratEst}
\title{Strategy Estimation Function}
\usage{
stratEst(
  data,
  strategies,
  shares,
  coefficients,
  covariates,
  sample.id,
  response = "mixed",
  sample.specific = c("shares", "probs", "trembles"),
  r.probs = "no",
  r.trembles = "global",
  select = NULL,
  min.strategies = 1,
  crit = "bic",
  se = "analytic",
  outer.runs = 1,
  outer.tol = 1e-10,
  outer.max = 1000,
  inner.runs = 10,
  inner.tol = 1e-05,
  inner.max = 10,
  lcr.runs = 100,
  lcr.tol = 1e-10,
  lcr.max = 1000,
  bs.samples = 1000,
  quantiles = c(0.01, 0.05, 0.5, 0.95, 0.99),
  stepsize = 1,
  penalty = F,
  verbose = TRUE
)
}
\arguments{
\item{data}{A \code{stratEst.data} object or \code{data.frame}. Must contain the variables \code{choice},  \code{input}, \code{id}, \code{game}, \code{period}. The variable \code{id} identifies observations of the same individual across games and periods. The factor \code{input} indicates the discrete information observed by the individual before making a choice. The factor \code{choice} indicates the choice of the individual.}

\item{strategies}{A list of strategies. Each strategy is a data.frame of class \code{stratEst.strategy}. Each row of the data.frame represents one state of the strategy. The first row defines the initial state which is entered if the variable input is NA. Column names which start with the string 'output.' indicate the columns which contain the multinomial choice probabilities of the strategy. For example, a column labeled 'output.x' contains the probability to observe the output 'x'. The column 'tremble' contains a tremble probability for pure strategies. Column names which start with the string 'input.' indicate the columns which contain the deterministic state transition of the strategy. For example, a column with name 'input.x' indicates the state transition after observing input 'x'.}

\item{shares}{A vector of strategy shares. The elements to the order of strategies in the list \code{strategies}. Shares which are \code{NA} are estimated from the data. With more than one sample and sample specific shares, a list of column vectors is required.}

\item{coefficients}{Column vector which contains the latent class regression coefficients. The elements correspond to the vector of estimates.}

\item{covariates}{A character vector indicating the names of the variables in data that are the covariates of the latent class regression model. Rows with the same id must have the values of covariates. Missing value are not allowed.}

\item{sample.id}{A character indicating the name of the variable which identifies the samples. Individual observations must be nested in samples. The same must be true for clusters if specified. If more than one sample exists, shares are estimated for each sample. All other parameters are estimated for the data of all samples. If the object is not supplied, it is assumed that the data contains only one sample.}

\item{response}{A string which can be set to \code{"pure"} or \code{"mixed"}. If set to \code{"pure"} all estimated choice probabilities are pure, i.e. either zero or one. If set to \code{"mixed"} all estimated choice probabilities are mixed. The default is \code{"mixed"}.}

\item{sample.specific}{A character vector defining which model parameters are sample specific. If the vector contains the character \code{"shares"} (\code{"probs"}, \code{"trembles"}), the estimation function estimates a set of shares (choice probabilities, trembles) for each sample in the data. If the vector does not contains the character \code{"shares"} (\code{"probs"}, \code{"trembles"}) one set of shares (choice probabilities, trembles) is estimated for the pooled data of all samples. Default is \code{c("shares","probs","trembles")}.}

\item{r.probs}{A string which can be set to \code{"no"}, \code{"strategies"}, \code{"states"} or \code{"global"}. If set to \code{"strategies"}, the estimation function estimates strategies with one strategy specific vector of choice probabilities in every state of the strategy. If set to \code{"states"}, one state specific vector of choice probabilities is estimated for each state. If set to \code{"global"}, a single vector of probabilities is estimated which applies in every state of each strategy. Default is \code{"no"}.}

\item{r.trembles}{A string which can be set to \code{"no"}, \code{"strategies"}, \code{"states"} or \code{"global"}. If set to \code{"strategies"}, the estimation unction estimates strategies with one strategy specific tremble probability. If set to  \code{"states"}, one state specific tremble probability is estimated for each state. If set to \code{"global"}, a single tremble probability is estimated which globally. Default is \code{"global"}.}

\item{select}{A character vector indicating which model parameters are selected. If the vector contains the character \code{"strategies"} (\code{"probs"}, \code{"trembles"}), the number of strategies (choice probabilities, trembles) is selected based on the selection criterion specified in \code{"crit"}. The selection of choice probabilities and trembles occurs obeying the restriction specified in \code{r.probs} and \code{r.trembles}. (E.g. if \code{r.probs} is set to \code{"strategies"}, \code{select = "probs"} will select the sets of choice probabilities within each strategy). Default is \code{NULL}.}

\item{min.strategies}{An integer which specifies the minimum number of strategies in case of strategy selection. The strategy selection procedure stops if the minimum is reached.}

\item{crit}{A string which can be set to \code{"bic"}, \code{"aic"} or \code{"icl"}. If set to \code{"bic"}, model selection based on the Bayesian Information criterion is performed. If set to \code{"aic"}, the Akaike Information criterion is used. If set to \code{"icl"} the Integrated Classification Likelihood criterion is used. Default is \code{"bic"}.}

\item{se}{A string which can be set to \code{"analytic"} or \code{"bootstrap"}. If set to \code{"bootstrap"}, bootstrapped standard errors are reported. Default is \code{"analytic"}.}

\item{outer.runs}{A positive integer which stets the number of outer runs of the solver. Default is 1.}

\item{outer.tol}{A positive number which stets the tolerance of the continuation condition of the outer runs. The iterative algorithm stops if the relative decrease of the log-likelihood is smaller than \code{outer.tol}. Default is 0.}

\item{outer.max}{A positive integer which stets the maximum number of iterations of the outer runs of the solver. The iterative algorithm stops if it did not converge after \code{"outer.max"} iterations. Default is 1000.}

\item{inner.runs}{A positive integer which stets the number of inner runs of the solver. Default is 10.}

\item{inner.tol}{A positive number which stets the tolerance of the continuation condition of the inner EM runs. The iterative algorithm stops if the relative decrease of the log-likelihood is smaller than \code{inner.tol}. Default is 0.}

\item{inner.max}{A positive integer which stets the maximum number of iterations of the inner EM runs. The iterative algorithm stops if it did not converge after \code{inner.max} iterations. Default is 10.}

\item{lcr.runs}{A positive integer which stets the number of estimation runs for latent class regression. Default is 100.}

\item{lcr.tol}{A positive number which stets the tolerance of the continuation condition of the Latent Class Regression runs. The iterative algorithm stops if the relative decrease of the log-likelihood is smaller than \code{lcr.tol}. Default is 0.}

\item{lcr.max}{A positive integer which stets the maximum number of iterations of the Latent Class Regression EM runs. The iterative algorithm stops if it did not converge after \code{lcr.max} iterations. Default is 1000.}

\item{bs.samples}{A positive integer which sets the number of bootstrap samples drawn with replacement.}

\item{quantiles}{A numeric vector indicating the quantiles of the sampling distribution of the estimated parameters. The quantiles are identified based on the standard error or based on bootstrapping the sampling distribution of the parameter.}

\item{stepsize}{A positive number which sets the stepsize of the Fisher scoring algorithm used to estimate the coefficients of the latent class regression model. Default is one. Values smaller than one slow down the convergence of the algorithm.}

\item{penalty}{A logical indicating if the Firth penalty is used to estimate the coefficients of the latent class regression model. Default is \code{FALSE}. Irrespective of the value specified here, the penalty is used in the case of a bootstrap of the standard errors of latent class regression coefficients.}

\item{verbose}{A logical, if \code{TRUE} messages of the estimation process and a summary of the estimated model is printed to the console. Default is \code{TRUE}.}
}
\value{
An object of class \code{stratEst}. A list with the following elements.
\item{strategies}{A list of fitted strategies.}
\item{shares}{Matrix of strategy shares. The order of rows corresponds to the order of strategies defined in the input object \code{strategies}.}
\item{probs}{Matrix of choice probabilities. The value \code{NA} indicates that the probability could not be estimated since data does not contain observations the model assigns to the corresponding state.}
\item{trembles}{Matrix of tremble probabilities of the strategies. The value \code{NA} indicates that the corresponding probability could not be estimated since data does not contain observations the model assigns to the corresponding state.}
\item{coefficients}{Matrix of latent class regression coefficients for strategies.}
\item{shares.par}{Estimated strategy shares.}
\item{probs.par}{Estimated choice probabilities.}
\item{trembles.par}{Estimated tremble probabilities.}
\item{coefficients.par}{Estimated latent class regression coefficients.}
\item{shares.indices}{Indices of strategy shares.}
\item{probs.indices}{Indices of choice probabilities.}
\item{trembles.indices}{Indices of tremble probabilities.}
\item{coefficients.indices}{Indices of latent class regression coefficients.}
\item{loglike}{The log-likelihood of the model. Larger values indicate a better fit of the model to the data.}
\item{crit.val}{The value of the selection criterion defined under \code{crit}. Larger values indicate a better fit of the model.}
\item{eval}{Number of iterations of the solver. The reported number is the sum of iterations performed in the inner and the outer run which produced the reported estimates.}
\item{tol.val}{The relative decrease of the log-likelihood in the last iteration of the algorithm. }
\item{convergence}{Maximum absolute score of the model parameters. Small values indicate convergence of the algorithm to a (local) maximum of the negative log likelihood.}
\item{entropy}{Entropy of the posterior probability assignments of individuals to strategies.}
\item{state.obs}{A column vector with the number of weighted observations for each strategy state corresponding to the rows of \code{strategies}.}
\item{posterior.assignments}{Posterior probability of each individual to use a strategy.}
\item{prior.assignments}{Prior probability of each individual to use a strategy as predicted by the individual covariates.}
\item{shares.se}{Standard errors of the estimated shares.}
\item{probs.se}{Standard errors of the estimated choice probabilities.}
\item{trembles.se}{Standard errors of the estimated trembles.}
\item{coefficients.se}{Standard errors of the estimated coefficients.}
\item{shares.score}{Score of the estimated shares.}
\item{probs.score}{Score of the reported choice probabilities.}
\item{trembles.score}{Score of the reported trembles.}
\item{coefficients.score}{Score of the reported coefficients.}
\item{shares.fisher}{Fisher information of the estimated shares.}
\item{probs.fisher}{Fisher information of the reported choice probabilities.}
\item{trembles.fisher}{Fisher information of the reported trembles.}
\item{coefficients.fisher}{Fisher information of the reported coefficients.}
\item{num.obs}{Number of observations.}
\item{num.ids}{Number of individuals.}
\item{num.par}{Total number of model parameters.}
\item{free.par}{Total number of free model parameters.}
\item{res.degrees}{Residual degrees of freedom (num.ids - free.par).}
\item{shares.quantiles}{Quantiles of the estimated shares.}
\item{probs.quantiles}{Quantiles of the estimated choice probabilities.}
\item{trembles.quantiles}{Quantiles of the estimated tremble probabilities.}
\item{coefficients.quantiles}{Quantiles of the estimated latent class regression coefficients.}
\item{gammas}{Gamma parameter of the model.}
\item{gammas.par}{Estimated gamma parameters.}
\item{gammas.se}{Standard errors of the gamma parameters.}#
\item{aic}{Akaike information criterion.}
\item{bic}{Bayesian information criterion.}
\item{icl}{Integrated classification likelihood information criteria.}
}
\description{
Performs variants of the strategy estimation method.
}
\details{
The estimation function \code{stratEst()} returns maximum-likelihood estimates for the population shares and choice probabilities of a set of candidate strategies given some data from an economic experiment. Candidate strategies can be supplied by the user in the form of deterministic finite-state automata. The number and the complexity of strategies can be restricted by the user or selected based on information criteria. stratEst also features latent class regression to assess the influence of covariates on strategy choice.
}
\note{
The strategy estimation method was introduced by (Dal Bo & Frechette 2011) to estimate the relative frequency of a fixed set of pure strategies in the indefinitely repeated prisoner's dilemma. Breitmoser (2015) extended the method to the estimation of behavior strategies. The \pkg{stratEst} package uses the EM algorithm (Dempster, Laird & Rubin 1977) and the Newton-Raphson method to obtain maximum-likelihood estimates for the population shares and choice probabilities of a set of candidate strategies. The package builds on other software contributions of the R community. To increase speed the estimation procedures, the package uses integration of C++ and R achieved by the Rcpp package (Eddelbuettel & Francois 2011) and the open source linear algebra library for the C++ language RppArmadillo (Sanderson & Curtin 2016).
}
\references{
Breitmoser, Y. (2015): Cooperation, but no reciprocity: Individual strategies in the repeated prisoner's dilemma, \emph{American Economic Review}, 105, 2882-2910.

Dal Bo, P. and G. R. Frechette (2011): The evolution of cooperation in infinitely repeated games: Experimental evidence, \emph{American Economic Review}, 101, 411-429.

Dempster, A., N. Laird, and D. B. Rubin (1977): Maximum likelihood from incomplete data via the EM algorithm," \emph{Journal of the Royal Statistical Society Series B}, 39, 1-38.

Eddelbuettel, D. and R. Francois (2011): Rcpp: Seamless R and C++ Integration, \emph{Journal of Statistical Software}, 40, 1-18.

Sanderson, C. and R. Curtin (2016): Armadillo: a template-based C++ library for linear algebra. \emph{Journal of Open Source Software}, 1-26.
}
