% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsc.input.R
\name{fsc.input}
\alias{fsc.input}
\alias{fscSettings}
\alias{fscDeme}
\alias{fscSettingsDemes}
\alias{fscEvent}
\alias{fscSettingsEvents}
\alias{fscSettingsMigration}
\alias{fscBlock_dna}
\alias{fscBlock_microsat}
\alias{fscBlock_snp}
\alias{fscBlock_standard}
\alias{fscBlock_freq}
\alias{fscSettingsGenetics}
\alias{fscEstParam}
\alias{fscSettingsEst}
\alias{fscSettingsDef}
\title{Input functions for fastsimcoal parameters}
\usage{
fscDeme(deme.size, sample.size, sample.time = 0, inbreeding = 0, growth = 0)

fscSettingsDemes(..., ploidy = 2)

fscEvent(
  event.time = 0,
  source = 0,
  sink = 0,
  prop.migrants = 1,
  new.size = 1,
  new.growth = 0,
  migr.mat = 0
)

fscSettingsEvents(...)

fscSettingsMigration(...)

fscBlock_dna(
  sequence.length,
  mut.rate,
  recomb.rate = 0,
  transition.rate = 1/3,
  chromosome = 1
)

fscBlock_microsat(
  num.loci,
  mut.rate,
  recomb.rate = 0,
  gsm.param = 0,
  range.constraint = 0,
  chromosome = 1
)

fscBlock_snp(sequence.length, mut.rate, recomb.rate = 0, chromosome = 1)

fscBlock_standard(num.loci, mut.rate, recomb.rate = 0, chromosome = 1)

fscBlock_freq(mut.rate, outexp = TRUE)

fscSettingsGenetics(..., num.chrom = NULL)

fscEstParam(
  name,
  is.int = TRUE,
  distr = c("unif", "logunif"),
  min = NA,
  max = NA,
  value = NA,
  output = TRUE,
  bounded = FALSE,
  reference = FALSE
)

fscSettingsEst(..., obs.sfs, rules = NULL, sfs.type = c("maf", "daf"))

fscSettingsDef(mat)
}
\arguments{
\item{deme.size}{the number of individuals in the deme.}

\item{sample.size}{the number of samples to take.}

\item{sample.time}{the number of generations in the past at which samples are
taken.}

\item{inbreeding}{the inbreeding coefficient for the deme \code{[0:1]}.}

\item{growth}{the growth rate of the deme.}

\item{...}{a set of comma-separated values for settings. See 
Notes for more information.}

\item{ploidy}{the desired ploidy of the final data. \code{deme.size} and 
\code{sample.size} will be multiplied by this value in the parameter or 
template file as \code{fastsimcoal2} generates haploid data.}

\item{event.time}{the number of generations before present at which the
historical event happened.}

\item{source}{the source deme (the first listed deme has index 0).}

\item{sink}{the sink deme.}

\item{prop.migrants}{the expected proportion of migrants to move from the
source to the sink deme.}

\item{new.size}{the new size for the sink deme, relative to its size in the
previous (later in time) generation.}

\item{new.growth}{the new growth rate for the sink deme.}

\item{migr.mat}{the number of the new migration matrix to be used further
back in time. The matrices are those supplied to the
\code{fscSettingsMigration} function. The first matrix has index 0.}

\item{sequence.length}{number of base pairs to use for each block.}

\item{mut.rate}{per base pair or locus mutation rate.}

\item{recomb.rate}{recombination rate between adjacent markers. No effect for
SNPs.}

\item{transition.rate}{dna: fraction of substitutions that are transitions.}

\item{chromosome}{number or character identifying which chromosome the marker
is on.}

\item{num.loci}{number of loci to simulate.}

\item{gsm.param}{value of the geometric parameter for a Generalized Stepwise
Mutation (GSM) model. This value represents the proportion of mutations
that will change the allele size by more than one step. Values between 0
and 1 are required. A value of 0 is for a strict Stepwise Mutation Model
(SMM).}

\item{range.constraint}{\code{msat}: Range constraint (number of different
alleles allowed). A value of 0 means no range constraint.}

\item{outexp}{logical describing if the expected site frequency
spectrum given the estimated parameters should be output?}

\item{num.chrom}{the number of chromosomes to be simulated. If this is
specified and not the same as the number of linkage blocks specified by the
\code{fscBlock_} functions, then this many chromosomes with duplicated
structures will be simulated. If \code{num.chrom = NULL}, then the
chromosome specification for each block will be used.}

\item{name}{name of the parameter being specified. Must match a name used in
one of the simulation settings functions.}

\item{is.int}{logical specifying whether or not the parameter is an integer.}

\item{distr}{a character string giving the distribution to use to select initial values for
parameter estimation. Can be \code{"unif"} or \code{"logunif"}.}

\item{min, max}{minimum and maximum values for the distribution specified in \code{distr}.}

\item{value}{character string giving the value that the complex parameter is
to take.}

\item{output}{logical indicating if estimates for the parameter should be
output.}

\item{bounded}{logical indicating whether to treat the parameter as a bounded
estimate.}

\item{reference}{logical indicating whether the parameter is to be used as a
reference.}

\item{obs.sfs}{vector, matrix, or list containing observed SFS to use for
parameter estimation.}

\item{rules}{character vector giving rules for the parameter estimation.}

\item{sfs.type}{type of SFS to write. Can be \code{maf} or \code{daf}.}

\item{mat}{numeric matrix or data frame with values of parameters to use in
place of parameter names in simulation.}
}
\description{
These functions specify and format simulation parameters used to
  write fastsimcoal2 parameter or template files, parameter estimation files, 
  parameter definition files, and site frequency spectrum files.
}
\note{
All settings must be passed to \code{\link{fscWrite}} using one
  of the \code{fscSettingsXXX} functions. Most of these functions in turn
  take as their input comma-separated values which are the result of specific
  \code{fscXXX} functions:\cr
  \describe{ 
    \item{fscSettingsDemes()}{comma-separated instances of fscDeme(). If 
       names are given for each deme, these names will be used in the parsed 
       output.} 
    \item{fscSettingsEvents()}{comma-separated instances of fscEvent().} 
    \item{fscSettingsMigration()}{comma-separated migration matrices.} 
    \item{fscSettingsGenetics()}{comma-separated instances of 
      fscBlock_dna(), fscBlock_microsat(), fscBlock_snp(), 
      fscBlock_standard(), or fscBlock_freq(). SNPs are simulated as a 
      DNA sequence with a transiton rate of 1. `fscBlock_freq()` can only 
      be used by itself and in parameter estimation simulations.} 
    \item{fscSettingsEst()}{comma-separated instances of fscEstParam() 
      as well as site frequency spectra (\code{obs.sfs}) and
      parameter rules {\code{rules}}.}
  }
  \code{fastsimcoal2} is not included with `strataG` and must be downloaded 
    separately. Additionally, it must be installed such that it can be run
    from the command line in the current working directory. 
    The function \code{fscTutorial()} will open a detailed tutorial on the 
    interface in your web browser.
}
\examples{
# three demes with optional names
demes <- fscSettingsDemes(
  Large = fscDeme(10000, 10), 
  Small = fscDeme(2500, 10),
  Medium = fscDeme(5000, 3, 1500)
)

# four historic events
events <- fscSettingsEvents(
  fscEvent(event.time = 2000, source = 1, sink = 2, prop.migrants = 0.05),
  fscEvent(2980, 1, 1, 0, 0.04),
  fscEvent(3000, 1, 0),
  fscEvent(15000, 0, 2, new.size = 3)
 )
 
# four genetic blocks of different types on three chromosomes.  
genetics <- fscSettingsGenetics(
  fscBlock_snp(10, 1e-6, chromosome = 1),
  fscBlock_dna(10, 1e-5, chromosome = 1),
  fscBlock_microsat(3, 1e-4, chromosome = 2),
  fscBlock_standard(5, 1e-3, chromosome = 3)
)

#' same four genetic blocks of different types with same structure repeated three times.  
genetics <- fscSettingsGenetics(
  fscBlock_snp(10, 1e-6),
  fscBlock_dna(10, 1e-5),
  fscBlock_microsat(3, 1e-4),
  fscBlock_standard(5, 1e-3),
  num.chrom = 3
)

}
\references{
Excoffier, L. and Foll, M (2011) fastsimcoal: a continuous-time 
  coalescent simulator of genomic diversity under arbitrarily complex 
  evolutionary scenarios Bioinformatics 27: 1332-1334.\cr
  Excoffier, L., Dupanloup, I., Huerta-Sánchez, E., Sousa, V.C., 
  and M. Foll (2013) Robust demographic inference from genomic and SNP data. 
  PLOS Genetics, 9(10):e1003905. \cr
  \url{http://cmpg.unibe.ch/software/fastsimcoal2/}
}
\seealso{
\code{\link{fscWrite}}, \code{\link{fscRun}}, \code{\link{fscRead}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
