% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nopt.R
\name{Dst}
\alias{Dst}
\title{Variance of Stratified Pi-estimator of the Total}
\usage{
Dst(n, N, S)
}
\arguments{
\item{n}{a numeric vector, sample allocations in strata.}

\item{N}{a numeric vector, strata sizes.}

\item{S}{a numeric vector, standard deviations of a study variable in strata.}
}
\value{
The value of the variance.
}
\description{
Compute the variance of the stratified pi-estimator of the population total of the study variable
under simple random sampling without replacement design in each stratum. This variance takes the following form \cr
\out{<center>}\code{D(n_1,...,n_H) = \\sum_{h = 1}^{H} \\frac{N_h^2 S_h^2}{n_h} - \\sum_{h = 1}^{H} N_h S_h^2},\out{</center>} \cr
where \code{H} denotes total number of strata, \code{N_1,...,N_H} denote strata sizes, and
\code{S_1,...,S_H} denote standard deviations of a study variable in strata. \cr
}
\examples{
N <- c(3000, 4000, 5000, 2000)
S <- rep(1, 4)
n_ <- nopt(n = 190, N = N, S = S, M = c(100, 90, 70, 80))
Dst(n = n_, N, S)


}
\references{
Sarndal, C.-E., Swensson, B., and Wretman, J. (1992) \emph{Model Assisted Survey Sampling}. Chapter 3.7 \emph{Stratified Sampling}. Springer.
}
