% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_stratify.R
\name{build_prognostic_scores}
\alias{build_prognostic_scores}
\title{Build Prognostic Scores}
\usage{
build_prognostic_scores(data, treat, prognosis, outcome, pilot_fraction,
  pilot_sample)
}
\arguments{
\item{data}{\code{data.frame} with observations as rows, features as columns}

\item{treat}{string giving the name of column designating treatment
assignment}

\item{prognosis}{information on how to build prognostic scores.  Three
different input types are allowed: \enumerate{ \item vector of prognostic
scores for all individuals in the data set. Should be in the same order as
the rows of \code{data}. \item a \code{formula} for fitting a prognostic
model \item an already-fit prognostic score model}}

\item{outcome}{string giving the name of column with outcome information.
Required if prognostic_scores is specified.  Otherwise it will be inferred
from prog_formula}

\item{pilot_fraction}{numeric between 0 and 1 giving the proportion of
controls to be allotted for building the prognostic score (default = 0.1)}

\item{pilot_sample}{a data.frame of held aside samples for building
prognostic score model.}
}
\value{
a list of: analysis set, prognostic scores, pilot set, prognostic
  model, and outcome string
}
\description{
Not meant to be called externally. Given the arguments to auto_stratify,
build the prognostic scores and return the analysis set, the prognostic
scores, the pilot set, the prognostic model, and the outcome string.  The
primary function of this code is to determine the type of \code{prognosis}
and handle it appropriately.
}
\seealso{
\code{\link{auto_stratify}}
}
