% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.strata.R
\name{summary.strata}
\alias{summary.strata}
\title{This method formats and outputs the final results to the R console}
\usage{
\method{summary}{strata}(object, ...)
}
\arguments{
\item{object}{A list: An object of class "strata".}

\item{...}{Any data type: This argument can be any particular argument.}
}
\value{
\code{} returns the formatted output
}
\description{
This function defines the method for the "strata" class that has been created 
in the constructor function (strata.data() or strata.distr()) where all computed 
objects, via other relevant functions, are collated and passed as a list. The 
function extracts all individual objects from the "strata" class object and combines 
them into dataframes before writing the formatted outputs to the console. This 
is used for both cases, depending on either the data or a hypothetical distribution.
}
\examples{
\dontrun{
data <- rweibull(1000, shape=2, scale = 1.5)
res <- strata.data(data, h = 2, n=300)
summary(res)
}

}
\author{
Karuna Reddy <karuna.reddy@usp.ac.fj>\cr MGM Khan <khan_mg@usp.ac.fj>
}
