/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.gui.visualization.ClusterPanel;
import moa.gui.visualization.DataPoint;
import moa.gui.visualization.PointPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamPanel
extends JPanel
implements ComponentListener {
    private ClusterPanel highlighted_cluster = null;
    private double zoom_factor = 0.2;
    private int zoom = 1;
    private int width_org;
    private int height_org;
    private int activeXDim = 0;
    private int activeYDim = 1;
    private JPanel layerPoints;
    private JPanel layerMicro;
    private JPanel layerMacro;
    private JPanel layerGroundTruth;
    private BufferedImage pointCanvas;
    private pointCanvasPanel layerPointCanvas;
    private boolean pointsVisible = true;
    private boolean ANTIALIAS = false;

    public StreamPanel() {
        this.initComponents();
        this.layerPoints = this.getNewLayer();
        this.layerPoints.setOpaque(true);
        this.layerPoints.setBackground(Color.white);
        this.layerMicro = this.getNewLayer();
        this.layerMacro = this.getNewLayer();
        this.layerGroundTruth = this.getNewLayer();
        this.add(this.layerMacro);
        this.add(this.layerMicro);
        this.add(this.layerGroundTruth);
        this.add(this.layerPoints);
        this.layerPointCanvas = new pointCanvasPanel();
        this.add(this.layerPointCanvas);
        this.addComponentListener(this);
    }

    private JPanel getNewLayer() {
        JPanel layer = new JPanel();
        layer.setOpaque(false);
        layer.setLayout(null);
        return layer;
    }

    public void drawMicroClustering(Clustering clustering, Color color) {
        this.drawClustering(this.layerMicro, clustering, color);
    }

    public void drawMacroClustering(Clustering clustering, Color color) {
        this.drawClustering(this.layerMacro, clustering, color);
    }

    public void drawGTClustering(Clustering clustering, Color color) {
        this.drawClustering(this.layerGroundTruth, clustering, color);
    }

    public void setMicroLayerVisibility(boolean visibility) {
        this.layerMicro.setVisible(visibility);
    }

    public void setMacroLayerVisibility(boolean visibility) {
        this.layerMacro.setVisible(visibility);
    }

    public void setGroundTruthLayerVisibility(boolean visibility) {
        this.layerGroundTruth.setVisible(visibility);
    }

    public void setPointVisibility(boolean visibility) {
        this.pointsVisible = visibility;
        this.layerPoints.setVisible(visibility);
        if (!visibility) {
            this.layerPointCanvas.setVisible(false);
        }
    }

    void drawPointPanels(ArrayList<DataPoint> points, int timestamp, double decay_rate, double decay_threshold) {
        for (int p = 0; p < points.size(); ++p) {
            PointPanel pointPanel = new PointPanel(points.get(p), decay_rate, decay_threshold);
            this.layerPoints.add(pointPanel);
            pointPanel.updateLocation();
        }
        this.layerPointCanvas.setVisible(false);
        this.layerPoints.setVisible(this.pointsVisible);
    }

    public void drawPoint(DataPoint point) {
        this.layerPointCanvas.setVisible(this.pointsVisible);
        this.layerPoints.setVisible(false);
        if (!this.pointsVisible) {
            return;
        }
        Graphics2D imageGraphics = this.pointCanvas.createGraphics();
        if (this.ANTIALIAS) {
            imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int size = Math.min(this.getWidth(), this.getHeight());
        int x = (int)Math.round(point.value(this.getActiveXDim()) * (double)size);
        int y = (int)Math.round(point.value(this.getActiveYDim()) * (double)size);
        Color c = PointPanel.getPointColorbyClass((int)point.classValue(), 10.0f);
        imageGraphics.setColor(c);
        int psize = 4;
        int poffset = 2;
        imageGraphics.drawOval(x - poffset, y - poffset, psize, psize);
        imageGraphics.fillOval(x - poffset, y - poffset, psize, psize);
        this.layerPointCanvas.repaint();
    }

    private void drawCanvansClustering(JPanel layer, Graphics2D imageGraphics) {
        for (Component comp : layer.getComponents()) {
            if (!(comp instanceof ClusterPanel)) continue;
            ClusterPanel cp = (ClusterPanel)comp;
            cp.drawOnCanvas(imageGraphics);
        }
    }

    public void applyDrawDecay(float factor) {
        RescaleOp brightenOp = new RescaleOp(1.0f, 150.0f / factor, null);
        this.pointCanvas = brightenOp.filter(this.pointCanvas, null);
        this.layerPointCanvas.setImage(this.pointCanvas);
        this.layerPointCanvas.repaint();
    }

    private void drawClustering(JPanel layer, Clustering clustering, Color color) {
        layer.removeAll();
        for (int c = 0; c < clustering.size(); ++c) {
            SphereCluster cluster = (SphereCluster)clustering.get(c);
            ClusterPanel clusterpanel = new ClusterPanel(cluster, color, this);
            layer.add(clusterpanel);
            clusterpanel.updateLocation();
        }
        if (layer.isVisible() && this.pointsVisible) {
            Graphics2D imageGraphics = this.pointCanvas.createGraphics();
            imageGraphics.setColor(color);
            this.drawCanvansClustering(layer, imageGraphics);
            this.layerPointCanvas.repaint();
        }
        layer.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void screenshot(String filename, boolean svg, boolean png) {
        if (this.layerPoints.getComponentCount() == 0 && this.layerMacro.getComponentCount() == 0 && this.layerMicro.getComponentCount() == 0) {
            return;
        }
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        if (png) {
            Object object = this.getTreeLock();
            synchronized (object) {
                Graphics g = image.getGraphics();
                this.paintAll(g);
                try {
                    ImageIO.write((RenderedImage)image, "png", new File(filename + ".png"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (svg) {
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename + ".svg")));
                int width = 500;
                out.write("<?xml version=\"1.0\"?>\n");
                out.write("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
                out.write("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + width + "\" height=\"" + width + "\">\n");
                if (this.layerMicro.isVisible()) {
                    for (Component comp : this.layerMicro.getComponents()) {
                        if (!(comp instanceof ClusterPanel)) continue;
                        out.write(((ClusterPanel)comp).getSVGString(width));
                    }
                }
                if (this.layerMacro.isVisible()) {
                    for (Component comp : this.layerMacro.getComponents()) {
                        if (!(comp instanceof ClusterPanel)) continue;
                        out.write(((ClusterPanel)comp).getSVGString(width));
                    }
                }
                if (this.layerGroundTruth.isVisible()) {
                    for (Component comp : this.layerGroundTruth.getComponents()) {
                        if (!(comp instanceof ClusterPanel)) continue;
                        out.write(((ClusterPanel)comp).getSVGString(width));
                    }
                }
                if (this.layerPoints.isVisible()) {
                    for (Component comp : this.layerPoints.getComponents()) {
                        if (!(comp instanceof PointPanel)) continue;
                        PointPanel pp = (PointPanel)comp;
                        out.write(pp.getSVGString(width));
                    }
                }
                out.write("</svg>");
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StreamPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public ClusterPanel getHighlightedClusterPanel() {
        return this.highlighted_cluster;
    }

    public void setHighlightedClusterPanel(ClusterPanel clusterpanel) {
        this.highlighted_cluster = clusterpanel;
        this.repaint();
    }

    public void setZoom(int x, int y, int zoom_delta, JScrollPane scrollPane) {
        if (this.zoom == 1) {
            this.width_org = this.getWidth();
            this.height_org = this.getHeight();
        }
        this.zoom += zoom_delta;
        if (this.zoom < 1) {
            this.zoom = 1;
        } else {
            int size = (int)((double)Math.min(this.width_org, this.height_org) * this.zoom_factor * (double)this.zoom);
            this.setSize(new Dimension(size * this.zoom, size * this.zoom));
            this.setPreferredSize(new Dimension(size * this.zoom, size * this.zoom));
            scrollPane.getViewport().setViewPosition(new Point((int)((double)x * this.zoom_factor * (double)this.zoom + (double)x), (int)((double)y * this.zoom_factor * (double)this.zoom + (double)y)));
        }
    }

    public int getActiveXDim() {
        return this.activeXDim;
    }

    public void setActiveXDim(int activeXDim) {
        this.activeXDim = activeXDim;
    }

    public int getActiveYDim() {
        return this.activeYDim;
    }

    public void setActiveYDim(int activeYDim) {
        this.activeYDim = activeYDim;
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StreamPanel.this.formMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formMouseClicked(MouseEvent evt) {
        if (this.highlighted_cluster != null) {
            this.highlighted_cluster.highlight(false);
            this.highlighted_cluster = null;
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int size = Math.min(this.getWidth(), this.getHeight());
        this.layerMicro.setSize(new Dimension(size, size));
        this.layerMacro.setSize(new Dimension(size, size));
        this.layerGroundTruth.setSize(new Dimension(size, size));
        this.layerPoints.setSize(new Dimension(size, size));
        this.pointCanvas = new BufferedImage(size, size, 1);
        this.layerPointCanvas.setSize(new Dimension(size, size));
        this.layerPointCanvas.setImage(this.pointCanvas);
        Graphics2D imageGraphics = (Graphics2D)this.pointCanvas.getGraphics();
        imageGraphics.setColor(Color.white);
        imageGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        imageGraphics.dispose();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    class pointCanvasPanel
    extends JPanel {
        BufferedImage image = null;

        pointCanvasPanel() {
        }

        public void setImage(BufferedImage image) {
            this.setSize(image.getWidth(), image.getWidth());
            this.image = image;
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.image != null) {
                g2.drawImage(this.image, null, 0, 0);
            }
        }
    }
}

