/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import moa.cluster.SphereCluster;
import moa.gui.visualization.StreamPanel;

public class ClusterPanel
extends JPanel {
    private SphereCluster cluster;
    private double[] center;
    private static final int MIN_SIZE = 5;
    protected double decay_rate;
    protected int x_dim = 0;
    protected int y_dim = 1;
    protected Color col;
    protected Color default_color = Color.BLACK;
    protected double[] direction = null;
    protected StreamPanel streamPanel;
    protected int panel_size;
    protected int window_size;
    protected boolean highligted = false;
    private double r;

    public ClusterPanel(SphereCluster cluster, Color color, StreamPanel sp) {
        this.cluster = cluster;
        this.center = cluster.getCenter();
        this.r = cluster.getRadius();
        this.streamPanel = sp;
        this.default_color = this.col = color;
        this.setVisible(true);
        this.setOpaque(false);
        this.setSize(new Dimension(1, 1));
        this.setLocation(0, 0);
        this.initComponents();
    }

    public void setDirection(double[] direction) {
        this.direction = direction;
    }

    public void updateLocation() {
        this.x_dim = this.streamPanel.getActiveXDim();
        this.y_dim = this.streamPanel.getActiveYDim();
        if (this.cluster != null && this.center == null) {
            this.getParent().remove(this);
        } else {
            this.window_size = Math.min(this.streamPanel.getWidth(), this.streamPanel.getHeight());
            this.panel_size = (int)(2.0 * this.r * (double)this.window_size);
            if (this.panel_size < 5) {
                this.panel_size = 5;
            }
            this.setSize(new Dimension(this.panel_size + 1, this.panel_size + 1));
            this.setLocation((int)(this.center[this.x_dim] * (double)this.window_size - (double)(this.panel_size / 2)), (int)(this.center[this.y_dim] * (double)this.window_size - (double)(this.panel_size / 2)));
        }
    }

    public void updateTooltip() {
        this.setToolTipText(this.cluster.getInfo());
    }

    public boolean contains(int x, int y) {
        double dist = Math.sqrt(Math.pow(x - this.panel_size / 2, 2.0) + Math.pow(y - this.panel_size / 2, 2.0));
        return (double)(this.panel_size / 2 - 5) < dist && dist < (double)(this.panel_size / 2 + 5);
    }

    private void initComponents() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ClusterPanel.this.formMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 296, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 266, Short.MAX_VALUE));
    }

    private void formMouseClicked(MouseEvent evt) {
        this.streamPanel.setHighlightedClusterPanel(this);
    }

    protected void paintComponent(Graphics g) {
        this.updateLocation();
        if (this.highligted) {
            g.setColor(Color.BLUE);
        } else {
            g.setColor(this.default_color);
        }
        int c = this.panel_size / 2;
        if (this.cluster.getId() >= 0.0) {
            g.drawString("C" + (int)this.cluster.getId(), c, c);
        }
        g.drawOval(0, 0, this.panel_size, this.panel_size);
        if (this.direction != null) {
            double length = Math.sqrt(Math.pow(this.direction[0], 2.0) + Math.pow(this.direction[1], 2.0));
            g.drawLine(c, c, c + (int)(this.direction[0] / length * (double)this.panel_size), c + (int)(this.direction[1] / length * (double)this.panel_size));
        }
        this.updateTooltip();
    }

    public void highlight(boolean enabled) {
        this.highligted = enabled;
        this.repaint();
    }

    public boolean isValidCluster() {
        return this.center != null;
    }

    public int getClusterID() {
        return (int)this.cluster.getId();
    }

    public int getClusterLabel() {
        return (int)this.cluster.getGroundTruth();
    }

    public String getSVGString(int width) {
        StringBuffer out = new StringBuffer();
        int x = (int)(this.center[this.x_dim] * (double)this.window_size);
        int y = (int)(this.center[this.y_dim] * (double)this.window_size);
        int radius = this.panel_size / 2;
        out.append("<circle ");
        out.append("cx='" + x + "' cy='" + y + "' r='" + radius + "'");
        out.append(" stroke='green' stroke-width='1' fill='white' fill-opacity='0' />");
        out.append("\n");
        return out.toString();
    }

    public void drawOnCanvas(Graphics2D imageGraphics) {
        int x = (int)(this.center[this.x_dim] * (double)this.window_size - (double)(this.panel_size / 2));
        int y = (int)(this.center[this.y_dim] * (double)this.window_size - (double)(this.panel_size / 2));
        int radius = this.panel_size;
        imageGraphics.drawOval(x, y, radius, radius);
    }
}

