/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.filters;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import moa.core.InstancesHeader;
import moa.options.FloatOption;
import moa.options.MultiChoiceOption;
import moa.streams.filters.AbstractStreamFilter;
import weka.core.Instance;

public class ReplacingMissingValuesFilter
extends AbstractStreamFilter {
    private static final long serialVersionUID = 1470772215201414815L;
    public MultiChoiceOption numericReplacementStrategyOption = new MultiChoiceOption("numericReplacementStrategy", 's', "Replacement strategy for numeric attributes", new String[]{"Nothing", "LastKnownValue", "Mean", "Max", "Min", "Constant"}, new String[]{"Does nothing (doesn't replace missing values)", "Replaces with the last non missing value", "Replaces with mean of the processed instances so far", "Replaces with maximum of the processed instances so far", "Replaces with minimum of the processed instances so far", "Replaces with a constant value (default: zero)"}, 0);
    public MultiChoiceOption nominalReplacementStrategyOption = new MultiChoiceOption("nominalReplacementStrategy", 't', "Replacement strategy for nominal attributes", new String[]{"Nothing", "LastKnownValue", "Mode"}, new String[]{"Does nothing (doesn't replace missing values)", "Replaces with the last non missing value", "Replaces with the mode of the processed instances so far (most frequent value)"}, 0);
    public FloatOption numericalConstantValueOption = new FloatOption("numericalConstantValue", 'c', "Value used to replace missing values during the numerical constant strategy", 0.0);
    protected int numAttributes = -1;
    protected double[] columnsStatistics = null;
    protected long[] numberOfSamples = null;
    protected String[] lastNominalValues = null;
    protected HashMap<String, Integer>[] frequencies = null;
    protected int numericalSelectedStrategy = 0;
    protected int nominalSelectedStrategy = 0;

    public String getPurposeString() {
        return "Replaces the missing values with another value according to the selected strategy.";
    }

    public InstancesHeader getHeader() {
        return this.inputStream.getHeader();
    }

    public Instance nextInstance() {
        int i;
        Instance inst = (Instance)this.inputStream.nextInstance().copy();
        if (this.numAttributes < 0) {
            this.numAttributes = inst.numAttributes();
            this.columnsStatistics = new double[this.numAttributes];
            this.numberOfSamples = new long[this.numAttributes];
            this.lastNominalValues = new String[this.numAttributes];
            this.frequencies = new HashMap[this.numAttributes];
            for (i = 0; i < inst.numAttributes(); ++i) {
                if (!inst.attribute(i).isNominal()) continue;
                this.frequencies[i] = new HashMap();
            }
            this.numericalSelectedStrategy = this.numericReplacementStrategyOption.getChosenIndex();
            this.nominalSelectedStrategy = this.nominalReplacementStrategyOption.getChosenIndex();
        }
        block21: for (i = 0; i < this.numAttributes; ++i) {
            if (inst.attribute(i).isNumeric()) {
                if (inst.isMissing(i)) {
                    switch (this.numericalSelectedStrategy) {
                        case 0: {
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            inst.setValue(i, this.columnsStatistics[i]);
                            break;
                        }
                        case 5: {
                            inst.setValue(i, this.numericalConstantValueOption.getValue());
                            break;
                        }
                    }
                    continue;
                }
                switch (this.numericalSelectedStrategy) {
                    case 1: {
                        this.columnsStatistics[i] = inst.value(i);
                        break;
                    }
                    case 2: {
                        int n = i;
                        this.numberOfSamples[n] = this.numberOfSamples[n] + 1L;
                        this.columnsStatistics[i] = this.columnsStatistics[i] + (inst.value(i) - this.columnsStatistics[i]) / (double)this.numberOfSamples[i];
                        break;
                    }
                    case 3: {
                        this.columnsStatistics[i] = this.columnsStatistics[i] < inst.value(i) ? inst.value(i) : this.columnsStatistics[i];
                        break;
                    }
                    case 4: {
                        this.columnsStatistics[i] = this.columnsStatistics[i] > inst.value(i) ? inst.value(i) : this.columnsStatistics[i];
                        break;
                    }
                }
                continue;
            }
            if (!inst.attribute(i).isNominal()) continue;
            if (inst.isMissing(i)) {
                switch (this.nominalSelectedStrategy) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (this.lastNominalValues[i] == null) continue block21;
                        inst.setValue(i, this.lastNominalValues[i]);
                        break;
                    }
                    case 2: {
                        if (this.frequencies[i].isEmpty()) continue block21;
                        Map<String, Integer> sortedMap = MapUtil.sortByValue(this.frequencies[i]);
                        inst.setValue(i, sortedMap.entrySet().iterator().next().getKey());
                        break;
                    }
                }
                continue;
            }
            switch (this.nominalSelectedStrategy) {
                case 1: {
                    this.lastNominalValues[i] = inst.stringValue(i);
                    continue block21;
                }
                case 2: {
                    Integer previousCounter = this.frequencies[i].get(inst.stringValue(i));
                    if (previousCounter == null) {
                        previousCounter = 0;
                    }
                    previousCounter = previousCounter + 1;
                    this.frequencies[i].put(inst.stringValue(i), previousCounter);
                    continue block21;
                }
                default: {
                    continue block21;
                }
            }
        }
        return inst;
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    protected void restartImpl() {
        this.numAttributes = -1;
        this.columnsStatistics = null;
        this.numberOfSamples = null;
        this.lastNominalValues = null;
        this.frequencies = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapUtil {
        public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
            LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

                @Override
                public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                    return -((Comparable)o1.getValue()).compareTo(o2.getValue());
                }
            });
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : list) {
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
    }
}

