/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.yahoo.labs.samoa.instances.Instance;
import java.util.Arrays;
import moa.core.Example;
import moa.core.Measurement;
import moa.evaluation.ALClassificationPerformanceEvaluator;
import moa.evaluation.BasicClassificationPerformanceEvaluator;
import moa.evaluation.WindowClassificationPerformanceEvaluator;

public class ALWindowClassificationPerformanceEvaluator
extends WindowClassificationPerformanceEvaluator
implements ALClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    private BasicClassificationPerformanceEvaluator.Estimator acquisitionRateEstimator;
    private int acquiredInstances;

    @Override
    public void doLabelAcqReport(Example<Instance> trainInst, int labelAcquired) {
        this.acquisitionRateEstimator.add(labelAcquired);
        this.acquiredInstances += labelAcquired;
    }

    public int getAbsNumOfAcqInst() {
        return this.acquiredInstances;
    }

    public double getRelNumOfAcqInst() {
        return this.acquisitionRateEstimator.estimation();
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        Measurement[] measurements = super.getPerformanceMeasurements();
        measurements = Arrays.copyOf(measurements, measurements.length + 2);
        measurements[measurements.length - 2] = new Measurement("Abs Number of Label Acquisitions", this.getAbsNumOfAcqInst());
        measurements[measurements.length - 1] = new Measurement("Rel Number of Label Acquisitions", this.getRelNumOfAcqInst());
        return measurements;
    }

    @Override
    public void reset(int numClasses) {
        super.reset(numClasses);
        this.acquisitionRateEstimator = new WindowClassificationPerformanceEvaluator.WindowEstimator(this, this.widthOption.getValue());
        this.acquiredInstances = 0;
    }
}

