% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streambugs_aux.r
\name{streambugs.write.sys.def}
\alias{streambugs.write.sys.def}
\title{Write system definition of the streambugs ODE model}
\usage{
streambugs.write.sys.def(sys.def, file = NA)
}
\arguments{
\item{sys.def}{system definition generated by the function
\code{\link{streambugs.get.sys.def}}}

\item{file}{file name}
}
\description{
Write system definition of the streambugs ODE model into a human-readable
text file.
}
\examples{
m <- streambugs.example.model.toy()
sys.def <- streambugs.get.sys.def(y.names=m$y.names, par=m$par, inp=m$inp)
file.name <- tempfile(m$name, fileext=".dat")
streambugs.write.sys.def(sys.def, file.name)
file.show(file.name, delete.file=TRUE)

}
