% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R, R/predict_mlm_stressor.R,
%   R/predict_reg_asym.R, R/predict_reg_sine.R
\name{predict}
\alias{predict}
\alias{predict.mlm_stressor}
\alias{predict.reg_asym}
\alias{predict.reg_sine}
\title{Prediction Methods for Various Models}
\usage{
\method{predict}{mlm_stressor}(object, newdata, train_data = NULL, ...)

\method{predict}{reg_asym}(object, newdata, ...)

\method{predict}{reg_sine}(object, newdata, ...)
}
\arguments{
\item{object}{A `mlm_stressor`, `reg_asym`, or `reg_sine` object.}

\item{newdata}{A data.frame object that is the data to be predicted on.}

\item{train_data}{A data.frame object defaulted to `NULL`. This is only used
when an `mlm_stressor` object needs to be refitted.}

\item{...}{Extending the \link[stats]{predict} function default. In this
case, it is ignored.}
}
\value{
A data.frame of predictions if `mlm_stressor` object or vector of
 predicted values.
}
\description{
Predict values on `mlm_stressor`, `reg_asym`, or `reg_sine`
 objects. This expands the \link[stats]{predict} function.
}
\examples{
\dontshow{if (python_avail()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
 # mlm_stressor example
 lm_test <- data_gen_lm(20)
 create_virtualenv()
 mlm_lm <- mlm_regressor(Y ~ ., lm_test)
 predict(mlm_lm, lm_test)
\dontshow{\}) # examplesIf}
 # Asymptotic Examples
 asym_data <- data_gen_asym(10)
 asym_fit <- reg_asym(Y ~ ., asym_data)
 predict(asym_fit, asym_data)
 # Sinusoidal Examples
 sine_data <- data_gen_sine(10)
 sine_fit <- reg_sine(Y ~ ., sine_data)
 predict(sine_fit, sine_data)
}
