% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_detect}
\alias{stri_detect}
\alias{stri_detect_charclass}
\alias{stri_detect_coll}
\alias{stri_detect_fixed}
\alias{stri_detect_regex}
\title{Detect a Pattern Match}
\usage{
stri_detect(str, ..., regex, fixed, coll, charclass)

stri_detect_fixed(str, pattern)

stri_detect_charclass(str, pattern)

stri_detect_coll(str, pattern, opts_collator = NULL)

stri_detect_regex(str, pattern, opts_regex = NULL)
}
\arguments{
\item{str}{character vector with strings to search in}

\item{...}{additional arguments passed to the underlying functions;
\code{stri_detect} only}

\item{pattern,regex,fixed,coll,charclass}{character vector defining search patterns;
for more details refer to \link{stringi-search}}

\item{opts_collator}{a named list with \pkg{ICU} Collator's settings
as generated with \code{\link{stri_opts_collator}}; \code{NULL}
for default settings; \code{stri_detect_coll} only}

\item{opts_regex}{a named list with \pkg{ICU} Regex settings
as generated with \code{\link{stri_opts_regex}}; \code{NULL}
for default settings; \code{stri_detect_regex} only}
}
\value{
All the functions return a logical vector.
}
\description{
These functions determine, for each string in \code{str},
if there is at least one match to a corresponding \code{pattern}.
}
\details{
Vectorized over \code{str} and \code{pattern}.

If \code{pattern} is empty, then the result is \code{NA}
and a warning is generated.

\code{stri_detect} is a convenience function.
It calls either \code{stri_detect_regex},
\code{stri_detect_fixed}, \code{stri_detect_coll},
or \code{stri_detect_charclass}, depending on the argument used.
Unless you are a very lazy person, please call the underlying functions
directly for better performance.

See also \code{\link{stri_startswith}} and \code{\link{stri_endswith}}
for testing whether a string starts or ends with a given pattern
match, respectively.
}
\examples{
\donttest{
stri_detect_fixed(c("stringi R", "REXAMINE", "123"), c('i', 'R', '0'))
stri_detect_fixed(c("stringi R", "REXAMINE", "123"), 'R')

stri_detect_charclass(c("stRRRingi","REXAMINE", "123"),
   c("\\\\p{Ll}", "\\\\p{Lu}", "\\\\p{Zs}"))

stri_detect_regex(c("stringi R", "REXAMINE", "123"), 'R.')
stri_detect_regex(c("stringi R", "REXAMINE", "123"), '[[:alpha:]]*?')
stri_detect_regex(c("stringi R", "REXAMINE", "123"), '[a-zC1]')
stri_detect_regex(c("stringi R", "REXAMINE", "123"), '( R|RE)')
stri_detect_regex("stringi", "STRING.", opts_regex=stri_opts_regex(case_insensitive=TRUE))
}
}
\seealso{
Other search_detect: \code{\link{stri_endswith}},
  \code{\link{stri_endswith_charclass}},
  \code{\link{stri_endswith_coll}},
  \code{\link{stri_endswith_fixed}},
  \code{\link{stri_startswith}},
  \code{\link{stri_startswith_charclass}},
  \code{\link{stri_startswith_coll}},
  \code{\link{stri_startswith_fixed}};
  \code{\link{stringi-search}}
}

