% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_unique}
\alias{stri_unique}
\title{Extract Unique Elements}
\usage{
stri_unique(str, opts_collator = NULL)
}
\arguments{
\item{str}{character vector}

\item{opts_collator}{a named list with \pkg{ICU} Collator's options
as generated with \code{\link{stri_opts_collator}}, \code{NULL}
for default collation options}
}
\value{
Returns a character vector.
}
\description{
This function returns a character vector like \code{str},
but with duplicate elements removed.
}
\details{
As usual in \pkg{stringi}, no attributes are copied.
Unlike \code{\link{unique}}, this function
tests for canonical equivalence of strings (and not
whether the strings are just bytewise equal). Such an operation
is locale-dependent. Hence, \code{stri_unique} is significantly
slower (but much better suited for natural language processing)
than its base R counterpart.

See also \code{\link{stri_duplicated}} for indicating non-unique elements.
}
\examples{
\donttest{
# normalized and non-unicode-normalized version of the same code point:
stri_unique(c("\\u0105", stri_trans_nfkd("\\u0105")))
unique(c("\\u0105", stri_trans_nfkd("\\u0105")))

stri_unique(c("gro\\\\u00df", "GROSS", "Gro\\\\u00df", "Gross"),
   stri_opts_collator(strength=1))
}
}
\seealso{
Other locale_sensitive: \code{\link{\%s!==\%}},
  \code{\link{\%s!=\%}}, \code{\link{\%s<=\%}},
  \code{\link{\%s<\%}}, \code{\link{\%s===\%}},
  \code{\link{\%s==\%}}, \code{\link{\%s>=\%}},
  \code{\link{\%s>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_boundaries}},
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_wrap}}; \code{\link{stringi-locale}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search-coll}}
}

