% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_trans_tolower}
\alias{stri_trans_tolower}
\alias{stri_trans_totitle}
\alias{stri_trans_toupper}
\title{Transform String with Case Mapping}
\usage{
stri_trans_tolower(str, locale = NULL)

stri_trans_toupper(str, locale = NULL)

stri_trans_totitle(str, ..., opts_brkiter = NULL)
}
\arguments{
\item{str}{character vector}

\item{locale}{\code{NULL} or \code{""} for case mapping following
the conventions of the default locale, or a single string with
locale identifier, see \link{stringi-locale}.}

\item{...}{additional settings for \code{opts_brkiter}}

\item{opts_brkiter}{a named list with \pkg{ICU} BreakIterator's settings
as generated with \code{\link{stri_opts_brkiter}};
\code{NULL} for default break iterator, i.e. \code{word};
\code{stri_trans_totitle} only}
}
\value{
Each function returns a character vector.
}
\description{
These functions transform strings either to lower case,
UPPER CASE, or to Title Case.
}
\details{
Vectorized over \code{str}.

\pkg{ICU} implements full Unicode string case mappings. In general,
\itemize{
\item case mapping can change the number of code points and/or code units
   of a string,
\item is language-sensitive (results may differ depending on locale), and
\item is context-sensitive (a character in the input string may map
   differently depending on surrounding characters).
}

With \code{stri_trans_totitle}, if \code{word} \code{BreakIterator}
is used (the default), then the first letter of each word will be capitalized
and the rest will be transformed to lower case.
With a break iterator of type \code{sentence}, the first letter
of each sentence will be capitalized only.
Note that according the \pkg{ICU} User Guide,
the string \code{"one. two. three."} consists of one sentence.

For more general (but not locale dependent)
text transforms refer to \code{\link{stri_trans_general}}.
}
\examples{
stri_trans_toupper("\\u00DF", "de_DE") # small German Eszett / scharfes S
stri_cmp_eq(stri_trans_toupper("i", "en_US"), stri_trans_toupper("i", "tr_TR"))
stri_trans_toupper(c('abc', '123', '\\u0105\\u0104'))
stri_trans_tolower(c('AbC', '123', '\\u0105\\u0104'))
stri_trans_totitle(c('AbC', '123', '\\u0105\\u0104'))
stri_trans_totitle("GOOD-OLD cOOkiE mOnSTeR IS watCHinG You. Here HE comes!") # word boundary
stri_trans_totitle("GOOD-OLD cOOkiE mOnSTeR IS watCHinG You. Here HE comes!", type="sentence")
}
\references{
\emph{Case Mappings} -- ICU User Guide,
\url{http://userguide.icu-project.org/transforms/casemappings}
}
\seealso{
Other locale_sensitive: \code{\link{\%s!==\%}},
  \code{\link{\%s!=\%}}, \code{\link{\%s<=\%}},
  \code{\link{\%s<\%}}, \code{\link{\%s===\%}},
  \code{\link{\%s==\%}}, \code{\link{\%s>=\%}},
  \code{\link{\%s>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_all_words}},
  \code{\link{stri_extract_first_words}},
  \code{\link{stri_extract_last_words}};
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_locate_all_words}},
  \code{\link{stri_locate_first_boundaries}},
  \code{\link{stri_locate_first_words}},
  \code{\link{stri_locate_last_boundaries}},
  \code{\link{stri_locate_last_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search-coll}}

Other text_boundaries: \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_extract_all_words}},
  \code{\link{stri_extract_first_words}},
  \code{\link{stri_extract_last_words}};
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_locate_all_words}},
  \code{\link{stri_locate_first_boundaries}},
  \code{\link{stri_locate_first_words}},
  \code{\link{stri_locate_last_boundaries}},
  \code{\link{stri_locate_last_words}};
  \code{\link{stri_opts_brkiter}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_lines}},
  \code{\link{stri_split_lines1}},
  \code{\link{stri_split_lines1}}; \code{\link{stri_wrap}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search}}

Other transform: \code{\link{stri_trans_general}};
  \code{\link{stri_trans_isnfc}},
  \code{\link{stri_trans_isnfd}},
  \code{\link{stri_trans_isnfkc}},
  \code{\link{stri_trans_isnfkc_casefold}},
  \code{\link{stri_trans_isnfkd}},
  \code{\link{stri_trans_nfc}},
  \code{\link{stri_trans_nfd}},
  \code{\link{stri_trans_nfkc}},
  \code{\link{stri_trans_nfkc_casefold}},
  \code{\link{stri_trans_nfkd}};
  \code{\link{stri_trans_list}}
}

