% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{stri_trim_both}
\alias{stri_trim}
\alias{stri_trim_both}
\alias{stri_trim_left}
\alias{stri_trim_right}
\title{Trim Characters from the Left and/or Right Side of a String}
\usage{
stri_trim_both(str, pattern = "\\\\P{Wspace}")

stri_trim_left(str, pattern = "\\\\P{Wspace}")

stri_trim_right(str, pattern = "\\\\P{Wspace}")

stri_trim(str, side = c("both", "left", "right"), pattern = "\\\\P{Wspace}")
}
\arguments{
\item{str}{a character vector of strings to be trimmed}

\item{pattern}{a single pattern, specifying character
classes that should be preserved (see \link{stringi-search-charclass}). Defaults to
`\code{\\P\{Wspace\}}.}

\item{side}{character [\code{stri_trim} only]; defaults to \code{"both"}}
}
\value{
All these functions return a character vector.
}
\description{
These functions may be used e.g. to get rid of unnecessary
whitespaces from strings. Trimming ends at the first or
starts at the last \code{pattern} match.
}
\details{
Vectorized over \code{str} and \code{pattern}.

\code{stri_trim} is a wrapper, which calls \code{stri_trim_left}
or \code{stri_trim_right} as appropriate. It's slightly slower than trim_left or
trim_right, and so shouldn't be used except for convenience.

Contrary to many other string processing libraries,
our trimming functions are quite general. A character class,
given by \code{pattern},
may be adjusted to suit your needs (most often you will use the default
value). On the other hand, for replacing pattern matches with
arbitrary replacement string, see \code{\link{stri_replace}}.

Interestingly, with these functions you may sometimes extract data, which
in some cases require using regular expressions. E.g. you may get
\code{"23.5"} out of \code{"total of 23.5 bitcoins"}.

For trimming whitespaces, please note the difference
between Unicode binary property `\code{\\p\{Wspace\}}` (more general)
and general character category `\code{\\p\{Z\}}`,
see \link{stringi-search-charclass}.
}
\examples{
stri_trim_left("               aaa")
stri_trim_right("rexamine.com/", "\\\\p{P}")
stri_trim_both(" Total of 23.5 bitcoins. ", "\\\\p{N}")
stri_trim_both(" Total of 23.5 bitcoins. ", "\\\\p{L}")

}
\seealso{
Other search_charclass: \code{\link{stringi-search-charclass}},
  \code{\link{stringi-search}}

Other search_replace: \code{\link{stri_replace_all}},
  \code{\link{stri_replace_na}},
  \code{\link{stringi-search}}
}

