% Generated by roxygen2 (4.0.1): do not edit by hand
\name{calculateBalance}
\alias{calculateBalance}
\title{Calculate balance}
\usage{
calculateBalance(data, ref, lb = "prop", perDye = TRUE, hb = 1,
  ignoreCase = TRUE, debug = FALSE)
}
\arguments{
\item{data}{a data frame containing at least
'Sample.Name', 'Marker', 'Height', 'Allele', and Dye'.}

\item{ref}{a data frame containing at least
'Sample.Name', 'Marker', 'Allele'.}

\item{lb}{string. 'prop' is defualt and locus balance is calculated proportionally
'norm' locus balance is normalised in relation to the locus with the highest total peakheight.}

\item{perDye}{logical, default is TRUE and locus balance is calculated within each dye.
FALSE locus balance is calculated globally across all dyes.}

\item{hb}{numerical, definition of heterozygous balance. hb=1; HMW/LMW, hb=2; Max1(Ph)/Max2(Ph).}

\item{ignoreCase}{logical indicating if sample matching should ignore case.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with with columns 'Sample.Name', 'Marker', 'Delta', 'Hb', 'Lb', 'MPH', 'TPH'.
}
\description{
\code{calculateBalance} calculates the inter and intra locus balance.
}
\details{
Calculates the inter and intra locus balance for a dataset.
Only peaks corresponding to reference alleles will be included in analysis
(does not require filtered data).
Be careful to not have actual alleles marked as 'OL' in dataset.
It will lead to underestimation of the total peak height per locus/sample.
Also calculates the allele size difference between heterozygous alleles.
Takes 'slimmed' data for samples and references as input.
NB! Requires at least one row for each marker per sample, even if no data.
NB! 'X' and 'Y' will be handled as '1' and '2' respectively.
}
\examples{
data(ref2)
data(set2)
# Calculate average balances.
calculateBalance(data=set2, ref=ref2)
}

