% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.STS.R
\name{plot.STS}
\alias{plot.STS}
\title{Function for plotting STS objects}
\usage{
\method{plot}{STS}(
  x,
  n = 10,
  topics = NULL,
  lowerPercentile = 0.05,
  upperPercentile = 0.95,
  ...
)
}
\arguments{
\item{x}{Model output from sts.}

\item{n}{Sets the number of words used to label each topic.  In perspective
plots it approximately sets the total number of words in the plot.
n must be greater than or equal to 2}

\item{topics}{Vector of topics to display. Defaults to all topics.}

\item{lowerPercentile}{Percentile to calculate a representative negative sentiment document.}

\item{upperPercentile}{Percentile to calculate a representative positive sentiment document.}

\item{\dots}{Additional parameters passed to plotting functions.}
}
\description{
Produces a plot of the most likely words and their probabilities for each topic for different levels
of sentiment for an STS object.
}
\examples{
\donttest{
#Examples with the Gadarian Data
library("tm"); library("stm"); library("sts")
temp<-textProcessor(documents=gadarian$open.ended.response,
metadata=gadarian, verbose = FALSE)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta, verbose = FALSE)
out$meta$noTreatment <- ifelse(out$meta$treatment == 1, -1, 1)
## low max iteration number just for testing
sts_estimate <- sts(~ treatment*pid_rep, ~ noTreatment, out, K = 3, maxIter = 2)
plot(sts_estimate)
plot(sts_estimate, n = 10, topic = c(1,2))
}
}
