% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{find_pos_id_to_keep}
\alias{find_pos_id_to_keep}
\title{Find the pos ids to keep}
\usage{
find_pos_id_to_keep(pd)
}
\arguments{
\item{pd}{A temporary top level nest where the first expression is always a
top level expression, potentially cached.}
}
\description{
To make a parse table shallow, we must know which ids to keep.
\code{split(cumsum(pd_parent_first$parent < 1))} above puts comments with negative
parents in the same block as proceeding expressions. \code{find_pos_id_to_keep()}
must hence always keep comments. We did not use
\code{split(cumsum(pd_parent_first$parent < 1))} because then every comment is an
expression on its own and processing takes much longer for typical roxygen
annotated code
}
\keyword{internal}
