% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dym_sp.R
\name{plot_dym_sp}
\alias{plot_dym_sp}
\title{Species subniches dynamic}
\usage{
plot_dym_sp(
  subnic,
  sp,
  xlab = NULL,
  ylab = NULL,
  main = NA,
  col.axis = "azure3",
  lty.axis = 2,
  lwd.axis = 2,
  border.E = "#92c5de",
  col.E = "#92c5de",
  lty.E = 1,
  lwd.E = 1,
  border.NR = "#fdb462",
  col.NR = "#fdb462",
  border.SR = "#a1d99b",
  col.SR = "#a1d99b",
  col.SRc = "black",
  lty.SR = 1,
  lwd.SR = 1,
  pch.SR = 19,
  cex.SR = 1,
  lty.NR = 1,
  lwd.NR = 2,
  col.arrow = "black",
  col.sp = "black",
  cex.sp = 1,
  show.lines = F,
  angle.arrow = 20,
  lwd.arrow = 2,
  length.arrow = 0.1,
  font.sp = 1,
  posi.leg = "topleft",
  bty.leg = "n",
  ...
)
}
\arguments{
\item{subnic}{an object of class \code{subniche}.}

\item{sp}{a character string of the species name.}

\item{xlab}{label for x-axis, see \link[graphics]{title} for more details.}

\item{ylab}{label for y-axis, see \link[graphics]{title} for more details.}

\item{main}{a main title for the plot, see \link[graphics]{title} for more details.}

\item{col.axis}{axis color, see \link[graphics]{par} for more details.}

\item{lty.axis}{axis line type, see \link[graphics]{par} for more details.}

\item{lwd.axis}{axis width, see \link[graphics]{par} for more details.}

\item{border.E}{color border of E polygon, see \link[graphics]{polygon} for more details.}

\item{col.E}{inside color of E polygon, see \link[graphics]{polygon} for more details.}

\item{lty.E}{line type for the E border, see \link[graphics]{polygon} for more details.}

\item{lwd.E}{line width for the E border, see \link[graphics]{polygon} for more details.}

\item{border.NR}{color border of NR polygon, see \link[graphics]{polygon} for more details.}

\item{col.NR}{inside color of NR polygon, see \link[graphics]{polygon} for more details.}

\item{border.SR}{color border of SR polygon, see \link[graphics]{polygon} for more details.}

\item{col.SR}{inside color of SR polygon, see \link[graphics]{polygon} for more details.}

\item{col.SRc}{color of points representing the SR position, see \link[graphics]{points} for more details.}

\item{lty.SR}{line type for the SR border, see \link[graphics]{polygon} for more details.}

\item{lwd.SR}{line width for the SR border, see \link[graphics]{polygon} for more details.}

\item{pch.SR}{type of points representing the SR position, see \link[graphics]{points} for more details.}

\item{cex.SR}{size of points representing the SR position, see \link[graphics]{points} for more details.}

\item{lty.NR}{line type for the NR border, see \link[graphics]{polygon} for more details.}

\item{lwd.NR}{line width for the NR border, see \link[graphics]{polygon} for more details.}

\item{col.arrow}{arrow color, see \link[graphics]{arrows} for more details.}

\item{col.sp}{color of the species label representing the NR position, see \link[wordcloud]{textplot} for more details.}

\item{cex.sp}{size of the species label representing the NR position, see \link[wordcloud]{textplot} for more details.}

\item{show.lines}{if true, then lines are plotted between x,y and the word, for those words not covering their x,y coordinates, see \link[wordcloud]{textplot} for more details.}

\item{angle.arrow}{arrow angle head, see \link[graphics]{arrows} for more details.}

\item{lwd.arrow}{arrow width, see \link[graphics]{arrows} for more details.}

\item{length.arrow}{arrow head length, see \link[graphics]{arrows} for more details.}

\item{font.sp}{An integer which specifies which font to use for species label. 1 corresponds to plain text (the default), 2 to bold face, 3 to italic and 4 to bold italic, see \link[graphics]{par} for more details.}

\item{posi.leg}{setting legend positions with the following keywords "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" and "center", see \link[graphics]{legend} for more details.}

\item{bty.leg}{the type of box to be drawn around the legend. The allowed values are "o" (the default) and "n", see \link[graphics]{legend} for more details.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
The function represents the species' subniches SR within its realized niche NR.
}
\details{
The convex hulls measured are :
\enumerate{
\item E is the environmental space.
\item NR the realized subniche.
\item SR the species realized subniche.}
The arrows represent the species' subniche marginality from the origin G.
See \href{https://doi.org/10.7717/peerj.3364}{Karasiewicz,et al. (2017)} for more details on the subniche concept.
}
\examples{
library(subniche)
data(doubs)
dudi1 <- dudi.pca(doubs$env, scale = TRUE, scan = FALSE, nf = 3)
nic1 <- niche(dudi1, doubs$fish, scann = FALSE)
# number of sites
N <- dim(nic1$ls)[1]
#Create a factor which defines the subsets
fact <- factor(c(rep(1,N/2),rep(2,N/2)))
# nic1 will be use as reference and fact will be use to define the subniches environment
subnic1 <- subniche(nic1, fact)
plot_dym_sp(subnic1, "Neba")
plot_dym_sp(subnic1,"Cyca", lwd.NR = 5, col.sp="red",lty.NR=3, border.E="green",col.E=NA, col.NR=NA)
}
