% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscreenvi.R
\name{subscreenvi}
\alias{subscreenvi}
\title{(iii) Determine variable importance}
\usage{
subscreenvi(data, y, cens = NULL, x = NULL, trt = NULL, ...)
}
\arguments{
\item{data}{The data frame containing the dependent and independent variables.}

\item{y}{The name of the column in \code{data} that contains the dependent variable.}

\item{cens}{The name of the column in \code{data} that contains the censoring variable, if \code{y} is an event time (default=NULL).}

\item{x}{Vector that contains the names of the columns in \code{data} with the independent variables (default=NULL, i.e. all remaining variables)}

\item{trt}{The name of the column in \code{data} that contains the treatment variable (default=NULL).}

\item{...}{additional arguments to be passed to function \code{rfsrc}}
}
\value{
A list containing ordered data frames with the variable importances
  (one for each treatment level, one with the ranking variability between the
  treatment levels and one with the total results)
}
\description{
Determine variable importance for continuous, categorical or right-censored
survival endpoints (overall and per treatment group) using random forests
}
\examples{
\dontrun{
require(survival)
data(pbc)
pbc$status <- ifelse(pbc$status==0,0,1)
importance <- subscreenvi(data=pbc, y='time', cens='status', trt='trt', x=NULL)
}
}
\keyword{importance}
\keyword{variable}
