% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_PreDeConStream.R
\name{DSC_PreDeConStream}
\alias{DSC_PreDeConStream}
\title{Density-Based Projected Clustering of Data Streams}
\usage{
DSC_PreDeConStream(epsilonN = 0.7, beta = 0.3, muN = 10, muF = 3,
  lambda = 0.1, initPoints = 1000, tau = 2, kappa = 10, delta = 0.01,
  offline = 2, speed = 100)
}
\arguments{
\item{epsilonN}{radius of each neighborhood}

\item{beta}{control the effect of mu}

\item{muN}{minimum number of points in microclusters}

\item{muF}{minimum number of points in macroclusters}

\item{lambda}{decaying parameter}

\item{initPoints}{number of points to use for initialization}

\item{tau}{number of maximal subspace dimensionality}

\item{kappa}{parameter to define preference weighted vector}

\item{delta}{defines the threshold for the variance}

\item{offline}{offline multiplier for epsilon}

\item{speed}{processing number of incoming points per time unit}
}
\description{
This function creates a DSC object that represents an instance of the
PreDeConStream algorithm and can be used for stream clustering.
}
\details{
The PreDeConStream algorithm is a Density-Based algorithm for the projected
clustering of data streams. To initially obtain a set of microclusters
\emph{initPoints} points are buffered and clustered using the 
\emph{PreDeCon} algorithm. Then, microclusters are maintained by checking for
each new point whether it falls within the radius of an existing microcluster,
similar to \link{DSC_DenStream}. Microclusters are aged according to a decay
paramter \emph{lambda}. Macroclusters are also maintained throughout the run
of the algorithm by updating the affected macroclusters, whenever a change in
the microcluster structure has occured, using a component of the
\emph{PreDeCon} algorithm to do so.
}
\examples{
dsc <- DSC_PreDeConStream()
dsd <- DSD_RandomRBFSubspaceGeneratorEvents()
update(dsc,dsd,1000)
}

