% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_units.R
\name{generate_units}
\alias{generate_units}
\title{Generate units with specified failure rate}
\usage{
generate_units(time, psi, n_sim = 20, cbaseh, inv_cbaseh, coxphmod = NULL,
  baseline_data, interval = c(0, 9e+12), mu = 0)
}
\arguments{
\item{time}{A numeric value indicating until what time from the start of the
study subjects can arrive.}

\item{psi}{Poisson arrival rate for subjects.}

\item{n_sim}{An integer indicating how many units should be generated.
Default is 20.}

\item{cbaseh}{A function returning the cumulative baseline hazard
at each relevant time point. Will be numerically inverted to generate
failure times. If
the inverse cumulative baseline hazard function is available, please specify
\code{inv_cbaseh} instead.}

\item{inv_cbaseh}{A function returning the inverse cumulative baseline
hazard at each relevant time point.}

\item{coxphmod}{(optional): A cox proportional hazards model generated using
\code{\link[survival:coxph]{coxph()}} or a list containing:
\describe{
\item{\code{formula}:}{a \code{\link[stats:formula]{formula()}} in the form \code{~ covariates};}
\item{\code{coefficients}:}{a named vector specifying risk adjustment coefficients
for covariates. Names must be the same as in \code{formula} and colnames of \code{data}.}
} If both \code{cbaseh} and \code{inv_cbaseh} are missing, the hazard rate
will be determined from \code{coxphmod}.}

\item{baseline_data}{(optional): A \code{data.frame} used for covariate resampling
with rows representing subjects and columns containing covariates to use for risk-adjustment.
Should only be specified in combination with \code{coxphmod}.}

\item{interval}{(optional) A numeric vector of length 2 indicating in which
range of values the failure times of subjects should be determined. By default,
failure times will be restricted between 0 and 9e12.}

\item{mu}{(optional) The increased log hazard ratio at the generated units with
respect to the specified baseline hazard rate. Default is log(1) = 0.}
}
\value{
A \code{data.frame} with rows representing subjects and the
following named columns:
\describe{
\item{\code{entrytime}:}{time of subject entry into the study;}
\item{\code{survtime}:}{survival time of subject;}
\item{\code{censorid}:}{censoring indicator, 0 = censored, 1 = observed;}
\item{\code{unit}:}{unit number;}
\item{\code{expmu}:}{exponent of the log hazard ratio used to generate
survival times;}
\item{\code{psival}:}{arrival rate at unit;}
\item{\code{covariates}:}{covariates resampled from \code{baseline_data}.}
}
}
\description{
Generate \code{n_sim} units with subjects arriving according to
a Poisson
process with rate \code{psi} until \code{time}. Failure rate is determined
either from \code{cbaseh} or \code{inv_cbaseh}, or from specified
\code{coxphmod}. Covariates will be resampled from \code{baseline_data} if
specified.
}
\details{
In a Poisson arrival process, inter-arrival times are exponentially
distributed with parameter \code{psi}. If \code{cbaseh} is specified,
the inverse baseline hazard will be determined using \code{\link[stats:uniroot]{uniroot()}}.
The times of failure are then determined using \code{\link[success:gen_surv_times]{gen_surv_times()}}.
}
\examples{
require(survival)
#Fit a Cox model
exprfit <- as.formula("Surv(survtime, censorid) ~ age + sex + BMI")
tcoxmod <- coxph(exprfit, data= surgerydat)

#Generate 30 hospitals with on average 2 patients per day arriving
#according to the Cox model determined above, with resampling from the
#original data set. The hazard rate at the hospitals is twice the baseline
#hazard.
generate_units(time = 50, psi = 2, n_sim = 30, coxphmod = tcoxmod,
baseline_data = surgerydat, mu = log(2))



}
\author{
Daniel Gomon
}
