% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sudokuAlt.R
\name{fetchUKGame}
\alias{fetchUKGame}
\title{Retrieve a Sudoku from the UK Site}
\usage{
fetchUKGame(day = NULL)
}
\arguments{
\item{day}{positive integer < 30, how many days ago? or NULL for
the most recently published game.}
}
\value{
The published sudoku game as a sudoku object.
}
\description{
Retrieve a Sudoku Game
}
\details{
Connects to \code{http://www.sudoku.org.uk/DailySudoku.asp} and retrieves
the sudoku game from \code{day} days ago.  Based on a function from a
related sudoku package, \code{sudoku::fetchSudokuUK} with minor changes.
}
\examples{
\dontrun{
(g0 <- fetchUKGame())  ## The game for today (according to GMT)
(g3 <- fetchUKGame(3)) ## game from 3 days ago (according to GMT)
if(require(sudoku)) {  ## the original solver
  g0a <- as.sudoku(fetchSudokuUK())  
  identical(g0, g0a)   ## should be TRUE
}
g0 \%>\% solve \%>\% plot -> sg0 ## spoil the game
}
}
\author{
Bill Venables
}
