% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-acf.R
\docType{data}
\name{geom_acf}
\alias{geom_acf}
\alias{GeomAcf}
\title{Autocorrelation for temporal data}
\usage{
geom_acf(mapping = NULL, data = NULL, position = "identity",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, lag.max = NULL,
  type = "correlation", level = 0.95, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{Logical. If \code{TRUE}, missing values are removed.  default is the
"correlation" and other options are "covariance" and "partial".}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{lag.max}{An integer indicating the maximum lag at which to calculate the
acf.}

\item{type}{A character string giving the type of the acf to be computed. The}

\item{level}{A numeric defining the confidence level. If \code{NULL}, no significant
line to be drawn.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
Since the data input is \code{data.frame}, it's better to sort the date-times
from early to recent and make implicit missing values explicit before using
\code{geom_acf}.
}
\examples{
library(dplyr)
fstaff <- pedestrian \%>\%
  filter(Sensor_ID == 13)

# use ggplot2 
fstaff \%>\%
  ggplot(aes(x = ..lag.., y = Hourly_Counts)) +
  geom_acf()

}
\keyword{datasets}
