% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d2b.R
\name{sund2bTooltip}
\alias{sund2bTooltip}
\title{Advanced Customization of 'd2b' Tooltip}
\usage{
sund2bTooltip(at = NULL, followMouse = NULL, html = NULL,
  my = NULL)
}
\arguments{
\item{at}{\code{character} which should be one of
"top left", "top center", "top right", "center left", "center center",
"center right", "bottom center", "bottom right" to specify
where the tooltip will be positioned relative to the hovered item.}

\item{followMouse}{\code{logical} controlling whether the tooltip
will follow the mouse instead of being placed in a static
position relative to the hovered element}

\item{html}{\code{character} or \code{htmlwidgets::JS} to customize the content
of the tooltip.  To provide a function, the arguments for the 'JavaScript'
function will be 'function(nodedata, size, percent)' and the function
should return a string.}

\item{my}{\code{character} which should be one of "top", "left", "right", "bottom"
to control the orientation of the tooltip.}
}
\value{
\code{list}
}
\description{
Advanced Customization of 'd2b' Tooltip
}
\examples{
if(interactive()){

library(sunburstR)

# use a sample of the sequences csv data
sequences <- read.csv(
  system.file("examples/visit-sequences.csv",package="sunburstR")
  ,header = FALSE
  ,stringsAsFactors = FALSE
)[1:200,]

# change the tooltip
sund2b(
  sequences,
  tooltip = sund2bTooltip(
    html = htmlwidgets::JS("
function(nodedata, size, percent) {
  return '<span style=\\"font-weight: bold;\\">' + nodedata.name + '</span>' + ' ' + size
}
    ")
  )
)


}
}
