% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBTrainer.R
\name{NBTrainer}
\alias{NBTrainer}
\title{Naive Bayes Trainer}
\description{
Trains a probabilistic naive bayes model
}
\details{
Trains a naive bayes model. It is built on top high performance naivebayes R package.
}
\examples{

## ------------------------------------------------
## Method `NBTrainer$new`
## ------------------------------------------------

data(iris)
nb <- NBTrainer$new()

## ------------------------------------------------
## Method `NBTrainer$fit`
## ------------------------------------------------

data(iris)
nb <- NBTrainer$new()
nb$fit(iris, 'Species')

## ------------------------------------------------
## Method `NBTrainer$predict`
## ------------------------------------------------

data(iris)
nb <- NBTrainer$new()
nb$fit(iris, 'Species')
y <- nb$predict(iris)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{prior}}{numeric vector with prior probabilities. vector with prior probabilities of the classes.
If unspecified, the class proportions for the training set are used.
If present, the probabilities should be specified in the order of the factor levels.}

\item{\code{laplace}}{value used for Laplace smoothing. Defaults to 0 (no Laplace smoothing)}

\item{\code{usekernel}}{if TRUE, density is used to estimate the densities of metric predictors}

\item{\code{model}}{for internal use}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{NBTrainer$new()}}
\item \href{#method-fit}{\code{NBTrainer$fit()}}
\item \href{#method-predict}{\code{NBTrainer$predict()}}
\item \href{#method-clone}{\code{NBTrainer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NBTrainer$new(prior, laplace, usekernel)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prior}}{numeric, prior numeric vector with prior probabilities. vector with prior probabilities of the classes.
If unspecified, the class proportions for the training set are used.
If present, the probabilities should be specified in the order of the factor levels.}

\item{\code{laplace}}{nuemric, value used for Laplace smoothing. Defaults to 0 (no Laplace smoothing)}

\item{\code{usekernel}}{logical, if TRUE, density is used to estimate the densities of metric predictors}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a new `NBTrainer` object.
}

\subsection{Returns}{
A `NBTrainer` object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(iris)
nb <- NBTrainer$new()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NBTrainer$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{data.frame containing train features}

\item{\code{y}}{character, name of target variable}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Fits the naive bayes model
}

\subsection{Returns}{
NULL, trains and saves the model in memory
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(iris)
nb <- NBTrainer$new()
nb$fit(iris, 'Species')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NBTrainer$predict(X, type = "class")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{data.frame containing test features}

\item{\code{type}}{character, if the predictions should be labels or probability}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Returns predictions from the model
}

\subsection{Returns}{
NULL, trains and saves the model in memory
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(iris)
nb <- NBTrainer$new()
nb$fit(iris, 'Species')
y <- nb$predict(iris)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NBTrainer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
