% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_export.R
\name{rmd_export}
\alias{rmd_export}
\title{Knit an R Markdown File and Export to Google Drive}
\usage{
rmd_export(
  rmd = NULL,
  out_path = getwd(),
  out_name = NULL,
  out_type = "html",
  drive_link
)
}
\arguments{
\item{rmd}{(character) name and path to R markdown file to knit}

\item{out_path}{(character) path to the knit file's destination (defaults to path returned by \code{getwd()})}

\item{out_name}{(character) desired name for knit file (with or without file suffix)}

\item{out_type}{(character) either "html" or "pdf" depending on what YAML entry you have in the \verb{output: } field of your R Markdown file}

\item{drive_link}{(character) full URL of drive folder to upload the knit document}
}
\value{
No return value, called to knit R Markdown file
}
\description{
This function allows you to knit a specified R Markdown file locally and export it to the Google Drive folder for which you provided a link. NOTE that if you have not used \code{googledrive::drive_auth} this will prompt you to authorize a Google account in a new browser tab. If you do not check the box in that screen before continuing you will not be able to use this function until you clear your browser cache and re-authenticate. I recommend invoking \code{drive_auth} beforehand to reduce the chances of this error
}
\examples{
\dontrun{
# Authorize R to interact with GoogleDrive
googledrive::drive_auth()
## NOTE: See warning about possible misstep at this stage

# Use `rmd_export()` to knit and export an .Rmd file
rmd_export(rmd = "my_markdown.Rmd",  in_path = getwd(), out_path = getwd(),
           out_name = "my_markdown", out_type = "html",
           drive_link = "<Google Drive folder URL>")
}

}
