% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.ptwiseELtest.R
\name{print.ptwiseELtest}
\alias{print.ptwiseELtest}
\title{Print a ptwiseELtest object}
\usage{
\method{print}{ptwiseELtest}(x, digits = max(3L, getOption("digits") - 3L), quiet = FALSE, ...)
}
\arguments{
\item{x}{the result of a call to the \code{ptwiseELtest} function}

\item{digits}{significant digits to print, the default value is \code{max(3L, getOption("digits") - 3L)}}

\item{quiet}{a logical indicating whether to reduce the amount of output or not, the default value is \code{FALSE}}

\item{...}{for future method}
}
\description{
Print some summary statistics for the observed uncensored time points, and the decisions, 
statistics, and critical values of the pointwise EL tests at those time points.
}
\examples{
library(survELtest)
result = ptwiseELtest(survival::Surv(hepatitis$time, hepatitis$censor)~
             hepatitis$group, sided = 1)
print(result)

## OUTPUT:
## Call:
## ptwiseELtest(formula = survival::Surv(hepatitis$time, hepatitis$censor) ~ 
##     hepatitis$group, sided = 1)
## 
## Range of time_pts is from 5.2 to 153.1
## 30 out of 45 decisions are 1, the other 15 decisions are 0
## -----
## Summary of stat_ptwise:
##    Min. 1st Qu.  Median    Mean 3rd Qu.    Max.
##   0.000   2.293   3.694   4.263   6.288  10.360 
## -----
## Summary of critval_ptwise:
##    Min. 1st Qu.  Median    Mean 3rd Qu.    Max.
##   2.117   2.346   2.483   2.509   2.669   2.951
}
\seealso{
\code{\link{hepatitis}}, \code{\link{ptwiseELtest}}, \code{\link{summary.ptwiseELtest}}
}
